# video-offnet-origin role class.
class video::offnet_origin {
  include libvmod_curl
  include libvmod_headercleaning
  include libvmod_timers2
  include twitch_nrdp
  include twitch_svclogs

  class { 'pachyderm': }
  class { 'gatekeeper': }
  class { 'twitch_cloudwatchlogs': }
  class { 'twitch_crashmonitor': }
  class { 'twitch::haproxy::video_offnet_origin': }

  class { 'video':
    role                  => 'offnet-origin',
    consul_port           => 80,
    consul_tags           => [ 'role-offnet-origin' ],
    varnish_daemon_params => {
      timeout_idle       => 10,
      send_timeout       => 30,
      idle_send_timeout  => 10,
      thread_pools       => 5,
      vcc_allow_inline_c => true,
    },
  }

  twitch_svclogs::logfile { 'varnishd':
    account      => 'twitch-dumbodrop',
    use_milliner => false,
  }

  offnet_netrr::dumbo_repo { 'dumbo_origin':
    ensure => 'absent',
  }

  class { 'varnishshmparser':
    node_type          => 'offnet-origin',
    statsd_sample_rate => $video::statsd_sample_rate,
  }

  # AES must be enabled on edges. check for it.
  realize(Twitch_nrdp::Check['check_aes'])
  realize(Twitch_nrdp::Check['check_varnish_stats'])
  realize(Twitch_nrdp::Check['check_sandstorm_agent','check_sandstorm_agent_ops'])
}
