class video::params {
  $use_bird        = hiera('use_bird', false)
  $statsd_host     = hiera('statsd_host', 'stats6.justin.tv')
  $statsd_port     = hiera('statsd_port', '8125')
  $sfo_servers     = better_range('hls1', 'hls133')
  $sfo_port        = 80
  $log_format      = '%h %l %u %t "%r" %s %b "%{Referer}i" "%{User-agent}i" %D %{Varnish:time_firstbyte}x %{Varnish:handling}x "%{VCL_Log:gk}x" "%{VCL_Log:replication_timestamps}x"'
  $vsl_query       = undef

  $use_varnish     = true
  $varnish_release = '4.1'
  $varnish_wd      = '/dev/shm/varnish'
  $vcl_files       = {}

  $raymundo_env        = ['production']
  $raymundo_deploy_env = 'production'
  $raymundo_deploydir  = '/opt/twitch'
  $raymundo_project    = 'video/raymundo'

  $raymundo_sec_offset = $::hostname ? {
    'job34' => 'export SECS_OFFSET=0',
    'job37' => 'export SECS_OFFSET=30',
    default => undef,
  }

  $raymundito_hours    = $::hostname ? {
    'job34' => [3,9,15,21],
    'job37' => [0,6,12,18],
    default => undef,
  }

  $usher_config = {
    'USHER_HOST'  => 'usher.justin.tv',
    'STATSD_HOST' => hiera('graphite_server', 'graphite-ingest.central.twitch.a2z.com:8125'),
  }

  $varnish_max_memory     = sprintf('%dm', $::memorysize_mb / 3 * 2)
  $varnish_listen         = ':80'
  $varnish_shared_memory  = '80m,10m'

  $varnish_daemon_params = {
    'timeout_idle'        => 60,
    'send_timeout'        => 60,
    'idle_send_timeout'   => 60,
    'thread_pool_min'     => 100,
    'thread_pool_max'     => 2000,
    'thread_pool_timeout' => 300,
    'cli_timeout'         => 60,
  }

  $varnish_upstream_override = undef

  $statsd_sample_rate     = 0.005
  $varnishncsa_enable     = true

  $consul_replication_tree = true
  $consul_controlled       = false
  $use_artm                = true
  $ensure_artm             = 'present'
  $varnish_config_file     = 'hls/artm-pre-start.vcl'
  $consul_tags             = []
  $consul_env              = pick($::twitch_environment, $twitch_environment, 'production')
  $consul_port             = undef

  $include_full_services  = true

  $weaver_hostname         = "video-weaver.${::pop}"
  $weaver_log_retain       = 36
  $weaver_haproxy_maxconns = 16000
}
