# This class configures video-pr servers in bare metal.
#
class video::pr {
  include libvmod_timers2
  include twitch_nrdp

  class { 'video':
    role              => 'replication',
    varnish_listen    => ':6081',
    consul_controlled => true,
    consul_port       => $video::consul_port,
    consul_tags       => [ 'role-pr' ],
    vsl_query         => $video::vsl_query,
  }

  class { 'twitch_crashmonitor':
    ensure => 'absent',
  }

  if $::network_drivers =~ /mlx5_core/ {
    class { 'irq_affinity':
      require => Class['twitch_dkms'],
    }

    class { 'twitch_irqbalance':
      policyscript => 'irqbalance_policy.sh';
    }
  }

  # This check is used to determine if this server is up or down.
  twitch_nrdp::check { 'server-status':
    command  => '/usr/local/monitor_scripts/check_video_hls_replication_enabled.sh',
    interval => 1,
    retry    => 1,
  }
}
