# Warp/Nydus specific video node
class video::warp (
  $consul_port       = 80,
  $consul_tags       = 'role-warp',
  $consul_env        = pick($::twitch_environment, $twitch_environment, 'production'),
  $consul_controlled = false,
) {

  # Advertise
  consul::service { 'video-hls-replication':
    ensure             => 'present',
    port               => $consul_port,
    consul_tags        => concat(["fqdn=${::fqdn}"], $consul_tags, $consul_env),
    maintmode_kv_watch => $consul_controlled,
  }

  # Services

  # Do not listen to TLS, as warp host does not have access to PoP TLS certs
  class { '::twitch_nydus':
    ensure => 'present',
    port   => 80,
    binary => 'nydus_edge',
  }

  class { '::warp':
    ensure => 'present',
  }

  # Monitoring
  include twitch_nrdp

  class { 'twitch_crashmonitor':
    ensure => 'absent',
  }

  class { 'twitch_cosmos':
    ensure               => 'present',
    node_type            => 'edge',
    haproxy_sockets_path => '/var/run/haproxy-video_edge-stats.*.sock',
  }

  # AES must be enabled on warp. check for it.
  realize(Twitch_nrdp::Check['check_aes'])

  # Optimizations
  if $::network_drivers =~ /mlx5_core/ {
    class { 'irq_affinity':
      require => Class['twitch_dkms'],
    }

    # TODO: move this to twitch_irqbalance/manifests/params.pp once
    # https://git-aws.internal.justin.tv/systems/puppet/pull/10124 has been merged
    class { 'twitch_irqbalance':
      policyscript => 'irqbalance_policy.sh';
    }
  }
}
