class video::weaver {
  class { 'video':
    role               => 'weaver',
    varnish_listen     => ':8080',

    varnish_max_memory => '16g',

    consul_port        => 8080,
    consul_tags        => [ 'role-weaver' ],
    log_format         => '%h %l %u %t "%r" %s %b "%{Referer}i" "%{User-agent}i" %D %{Varnish:time_firstbyte}x %{Varnish:handling}x "%{VCL_Log:gk}x"',
    vsl_query          => 'BerespStatus != 200 or RespStatus != 200',
  }

  class { '::weaver':
    upstream_url    => 'http://localhost:8080/upstream',

    redis_protocol  => 'tcp',
    redis_address   => 'localhost:6379',
    redis_cluster   => true,

    statsd_type     => 'weaver_cluster',

    beacon_url      => "http://${::fqdn}:7000",

    gatekeeper_fqdn => "${video::weaver_hostname}.hls.justin.tv",
    gatekeeper_name => $video::weaver_hostname,
  }

  class { 'edgeeventproxy':
    node_type      => 'weaver',
    type           => 'client',
    eeproxy_enable => false,
  }

  class { 'twitch_cosmos':
    ensure               => 'present',
    node_type            => 'weaver',
    haproxy_sockets_path => '/var/run/haproxy-video_weaver-stats.1.sock',
    redis_addr           => '127.0.0.1:6379',
  }

  # TODO: VIDCS-2715 - cleanup after completion of xenial migration to bionic
  # Separate conditional to maintain existing behavior on xenial
  if $::video::use_varnish {
    class { 'gatekeeper':
      ensure    => 'absent',
      host_name => "${video::weaver_hostname}.hls.justin.tv",
      node_name => $video::weaver_hostname,
    }

    class { 'varnishshmparser':
      node_type          => 'weaver',
      statsd_sample_rate => $video::statsd_sample_rate,
    }
  }

  class { 'twitch::haproxy::video_weaver':
    haproxy_maxconns => $video::weaver_haproxy_maxconns,
  }

  consul::service { 'video-weaver':
    service_name   => 'video-weaver',
    port           => 8000,
    consul_tags    => [ $video::consul_env ],
    check_http     => 'http://127.0.0.1:8000/health',
    check_interval => '5s',
  }

  include libvmod_headercleaning
  include libvmod_timers2

  class { 'twitch_crashmonitor':
    ensure => 'absent',
  }

  include twitch_nrdp
  realize(Twitch_nrdp::Check['check_aes'])

  sysctl::value { 'vm.min_free_kbytes': value => 2000000 }
  sysctl::value { 'vm.lowmem_reserve_ratio': value => '8 8 32' }
  sysctl::value { 'net.ipv4.tcp_slow_start_after_idle': value => 0 }
}
