# Edgeviewcounter receives edge events for segment and variant playlist
# requests and forwards relevant metrics to usher, spade and
# globalviewcount.

class video::workers::edgeviewcounter (
  $ensure                   = 'present',
  $options                  = '',
  $env                      = ['production'],
  $deploy_env               = 'production',
  $project                  = 'video/edgeviewcounter',
  $base_dir                 = '/opt/twitch',
  $use_videoapi             = true,
  $status_port              = 5000,
)
{

  validate_bool($use_videoapi)
  validate_integer($status_port)

  $port_videoapi = $use_videoapi ? {
    true  => '--usher-loc=video-api.internal.justin.tv --usher-port=80',
    false => '',
  }

  if 'staging' in $env {
    $globalviewcount_options = '-viewcount-addresses ""' # don't talk to production
  } else {
    $globalviewcount_options = '' # use default globalviewcount hostnames
  }

  $statsd_host = hiera('statsd_host')
  $statsd_port = hiera('statsd_port')
  validate_string($statsd_host)
  validate_numeric($statsd_port)

  $cmdline_args = join([
    $options,
    $port_videoapi,
    "--status-port=${status_port}",
    "--statsd-addr=${statsd_host}",
    "--statsd-port=${statsd_port}",
    $globalviewcount_options,
  ], ' ')

  daemontools::supervise { 'edgeviewcounter':
    ensure  => $ensure,
    syslog  => 'local3',
    wd      => "${base_dir}/edgeviewcounter/current",
    daemon  => './bin/edgeviewcounter',
    options => "${cmdline_args} 2>&1",
    user    => 'nobody',
    require => Courier::Install['edgeviewcounter'],
  }

  consul::service { 'edgeviewcounter':
    ensure       => $ensure,
    consul_tags  => $env,
    service_name => 'edgeviewcounter',
  }

  courier::install{ 'edgeviewcounter':
    ensure  => $ensure,
    env     => $deploy_env,
    repo    => $project,
    basedir => $base_dir,
    require => [
      Consul::Service['edgeviewcounter'],
      Class['consul'],
    ]
  }

  envoy::service { 'edgeviewcounter':
    ensure => $ensure,
    port   => $status_port,
  }

  # There used to be a file and nrpe::command definition here. The file and
  # definitions have been moved to twitch_monitoring_scripts and twitch_nrpe
  # Soon, realize(Twitch_nrdp::Command['edgeviewcounter_health']) will go here.
}
