class video::workers::hls_event_transcoder (
  $flags = '--cpu-max 60'
){
  include video::workers::params
  include video::workers::hls_transcleanup
  include video::workers::scripts

  $usher_addr     = $video::workers::params::usher_addr
  $vod_http_proxy = $video::workers::params::vod_http_proxy

  daemontools::supervise { 'hls_transcoder':
    predaemon => [
      template("${module_name}/worker_predaemon.erb"),
      'ulimit -m 7340032', # 7gb
      '. /etc/profile.d/proxy.sh',
      "export http_proxy=\"$vod_http_proxy\"",
      'export HTTP_PROXY=$http_proxy',
      'export https_proxy=$http_proxy',
      'export HTTPS_PROXY=$http_proxy',
      'export ftp_proxy=$http_proxy',
      'export FTP_PROXY=$http_proxy',
      'source /etc/milliner-client-env.sh',
    ],
    wd        => '/home/jtv/workers/current',
    syslog    => 'local3',
    daemon    => join([
      './bin/hls_event_transcoder',
      $flags,
      "--usher-addr=${usher_addr}",
      "--role=${::twitch_role}",
      "--environment=${::twitch_environment}",
      "--pop=${::pop}",
      '--syslog',
      '2>&1',
    ], ' '),
    user      => 'jtv',
    down      => true,
  }
}
