# The transmuxer and transcode workers, with syslog, 
# leave lots of extra log files in /var/log/archive.
# This class adds a simple crontab to clean them up.

class video::workers::hls_transcleanup () {
  # This command is pretty explicit about what it deletes. Safe not to log.
  $cron_cmd  = 'find /var/log/archive -maxdepth 1 -type f -name \*.bz2 -mtime +90 -delete'
  $cron_user = 'root'
  $cron_msg  = "# This file is managed by puppet.\n"
  # These three lines make the command run every day at a random hour:minute.
  $cleanup_hour = fqdn_rand(24, 'transcleanup_hour_seed')
  $cleanup_min  = fqdn_rand(60, 'transcleanup_min_seed' )
  $cron_time = "${cleanup_min} ${cleanup_hour} * * *"

  file { '/etc/cron.d/clean_log_archive':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => "${cron_msg}${cron_time} ${cron_user} ${cron_cmd}\n"
  }

}
