# video::workers::hls_transcoder
class video::workers::hls_transcoder (
  $flags = '',
  $max_proc_count = undef,
  $cpu_max = '65',
  $origin_on = false,
  $supervise_predaemon = [],
){
  validate_array($supervise_predaemon)

  include video::workers::params
  include video::workers::hls_transcleanup
  include video::workers::scripts

  $usher_addr     = $video::workers::params::usher_addr
  $vod_http_proxy = $video::workers::params::vod_http_proxy

  # optionally turn on video origin
  $origin_args = $origin_on ? {
    true    => '--hls-endpoint=http://localhost:9090',
    default => '',
  }

  $default_max_proc_count = $::processor0 ? {
    /E5-2630 v4/ => '3',
    default      => '2',
  }

  $max_proc_count_flag = $max_proc_count ? {
    undef   => "--max-proc-count=${default_max_proc_count}",
    default => "--max-proc-count=${max_proc_count}",
  }

  $cpu_max_flag = $cpu_max ? {
    undef   => '',
    default => "--cpu-max=${cpu_max}",
  }

  $_supervise_predaemon = [
    template("${module_name}/worker_predaemon.erb"),
    'ulimit -m 7340032', # 7gb
    '. /etc/profile.d/proxy.sh',
    "export http_proxy=\"${vod_http_proxy}\"",
    'export HTTP_PROXY=$http_proxy',
    'export https_proxy=$http_proxy',
    'export HTTPS_PROXY=$http_proxy',
    'export ftp_proxy=$http_proxy',
    'export FTP_PROXY=$http_proxy',
    'source /etc/milliner-client-env.sh',
  ]

  # VIDCS-2715 cleanup
  $service_user = $::lsbdistcodename ? {
    'bionic' => 'transcode',
    default  => 'jtv',
  }

  $intel_media_vars = $::twitch_role ? {
    'transcode-qs' => [
      'export LD_LIBRARY_PATH=/opt/quicksync/libva/lib:/opt/quicksync/gmmlib/lib:/opt/quicksync/media-driver/lib:/opt/quicksync/mediasdk/lib', # lint:ignore:140chars
      'export LIBVA_DRIVER_NAME=iHD',
      'export LIBVA_DRIVERS_PATH=/opt/quicksync/media-driver/lib/dri',
      'export MFX_HOME=/opt/quicksync/mediasdk',
    ],
    default        => undef,
  }

  daemontools::supervise { 'hls_transcoder':
    predaemon       => concat($_supervise_predaemon, $supervise_predaemon, $intel_media_vars),
    wd              => '/home/jtv/workers/current',
    syslog          => 'local3',
    daemon          => join([
      './bin/hls_transcoder',
      $flags,
      $origin_args,
      "--usher-addr=${usher_addr}",
      $max_proc_count_flag,
      $cpu_max_flag,
      "--role=${::twitch_role}",
      "--environment=${::twitch_environment}",
      "--pop=${::pop}",
      '--syslog',
      '2>&1',
    ], ' '),
    user            => $service_user,
  }

}
