class video::workers::hls_transmuxer (
  $flags = '',
  $max_proc_count = undef,
  $cpu_max = '80',
  $origin_on = false,
) {
  include video::workers::params
  include video::workers::hls_transcleanup
  include video::workers::scripts

  $rabbit_port = hiera('hls_rabbit_port', '')
  $usher_addr     = $video::workers::params::usher_addr
  $vod_http_proxy = $video::workers::params::vod_http_proxy

  # optionally turn on video origin
  $origin_args = $origin_on ? {
    true    => '--hls-endpoint=http://localhost:9090',
    default => '',
  }

  $max_proc_count_flag = $max_proc_count ? {
    undef   => '',
    default => "--max-proc-count=${max_proc_count}",
  }

  $cpu_max_flag = $cpu_max ? {
    undef   => '',
    default => "--cpu-max=${cpu_max}",
  }

  # VIDCS-2715 cleanup
  $service_user = $::lsbdistcodename ? {
    'bionic' => 'transcode',
    default  => 'jtv',
  }

  daemontools::supervise { 'hls_transmuxer':
    wd        => '/home/jtv/workers/current',
    syslog    => 'local3',
    predaemon => [
      template("${module_name}/worker_predaemon.erb"),
      'export LD_LIBRARY_PATH=/usr/local/lib',
      'ulimit -m 7340032',  # 7gb
      '. /etc/profile.d/proxy.sh',
      "export http_proxy=\"$vod_http_proxy\"",
      'export HTTP_PROXY=$http_proxy',
      'export https_proxy=$http_proxy',
      'export HTTPS_PROXY=$http_proxy',
      'export ftp_proxy=$http_proxy',
      'export FTP_PROXY=$http_proxy',
      'source /etc/milliner-client-env.sh',
    ],
    daemon    => join([
      './bin/transmuxer',
      "--rabbit-haproxy-port=${rabbit_port}",
      "--usher-addr=${usher_addr}",
      $flags,
      $origin_args,
      $cpu_max_flag,
      $max_proc_count_flag,
      "--role=${::twitch_role}",
      "--environment=${::twitch_environment}",
      "--pop=${::pop}",
      '--syslog',
      '2>&1',
    ], ' '),
    user      => $service_user,
  }
}
