class video::workers::params (
  $consul_service_name     = 'video-workers',
  $consul_tags             = ['workers'],
  $env                     = pick($facts['twitch_environment'], $twitch_environment, 'production'),
  $usher_addr              = 'usher.justin.tv',
  $twitchmedia_ingest_addr = 'live.twitch.tv',
  $vod_http_proxy          = 'http://localhost:12395/'
) {
  validate_string($twitchmedia_ingest_addr)
  validate_string($usher_addr)
  validate_string($consul_service_name)
  validate_string($env)

  consul::service { $consul_service_name:
    consul_tags  => [$env, $consul_tags],
  }

  file { "/etc/environment":
    content => inline_template("PATH=\"/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:\""),
  }

}
