class video::workers::proxy_monitor (
  $svcname = 'proxy_monitor',
  $proxymon_env = 'production',
  $haproxy_inst_name = 'live',
  $ingest_ip = $::ipaddress_primary,
) {
  include twitch::packages
  realize(Package['libspeex1'])
  realize(Package['libmp3lame0'])

  include video::workers::params

  daemontools::supervise { $svcname:
    syslog    => 'local3',
    user      => 'nobody',
    wd        => '/home/jtv/proxy_monitor/current',
    predaemon => ["test -f /etc/profile.d/proxy.sh && source /etc/profile.d/proxy.sh", "source /etc/milliner-client-env.sh"],
    daemon    => "./proxy_monitor",
    options   => "--ingest ${ingest_ip}:1935 --channel ${::fqdn}  --check-interval 50s --haproxy-config /etc/haproxy/haproxy-${haproxy_inst_name}.conf 2>&1"
  }

  consul::service { 'ingest-proxy-monitor':
    consul_tags    => [$proxymon_env],
    port           => 0,
  }

  courier::install{ 'proxy_monitor':
    env     => $proxymon_env,
    repo    => 'video/proxy_monitor',
    basedir => '/home/jtv',
    require => Consul::Service['ingest-proxy-monitor']
  }

  courier::install { 'video_deps':
    env     => 'production',
    repo    => 'video/video_deps',
    basedir => '/home/jtv',
  }
}
