# creates a supervise teststream service
define video::workers::teststream(
  $stream_name = $title,
  $channel_id = '',
  $res = '640x480',
  $ingest = 'live.twitch.tv',
  $tags=''
) {
$daemon=[
  '/usr/bin/ffmpeg',
  '-re',
  '-nostdin',
  '-f', 'lavfi',
  '-i', "testsrc=duration=3600:size=${res}:rate=30",
  '-f', 'lavfi',
  '-i', 'sine=frequency=1000',
  '-pix_fmt', 'yuv420p',
  '-profile:v', 'baseline',
  '-level', '3.0',
  '-r', '30',
  '-g', '60',
  '-shortest',
  '-vcodec', 'libx264',
  '-f', 'flv',
  "rtmp://${ingest}/app/\$STREAM_KEY?${tags}",
  '2>&1',
]
  video::workers::teststream_daemon{ $stream_name:
    daemon     => $daemon,
    channel_id => $channel_id
  }
}
