# creates a supervise teststream service
define video::workers::teststream_daemon(
  $stream_name = $title,
  $channel_id = '',
  $daemon      = [
    '/usr/bin/ffmpeg',
    '-re',
    '-nostdin',
    '-f', 'lavfi',
    '-i', 'testsrc=duration=3600:size=640x480:rate=30',
    '-f', 'lavfi',
    '-i', 'sine=frequency=500',
    '-pix_fmt', 'yuv420p',
    '-profile:v', 'baseline',
    '-level', '3.0',
    '-r', '30',
    '-g', '60',
    '-shortest',
    '-vcodec', 'libx264',
    '-f', 'flv',
    'rtmp://live.twitch.tv/app/\$STREAM_KEY',
    '2>&1',
  ],
  $predaemon   = "STREAM_KEY=\$(/usr/local/bin/get_stream_key.py '${channel_id}')",
) {
  daemontools::supervise { "teststream_${stream_name}":
    wd        => '/tmp/',
    syslog    => 'local3',
    user      => 'nobody',
    predaemon => [$predaemon],
    daemon    => join($daemon, ' '),
  }
}
