#twitchmediastream_cmh.pp
# Group of test streams in cmh01 (These are DR streams. Please put all DR streams here)
class video::workers::twitchmediastream_cmh {
  file { '/usr/local/bin/get_stream_key.py':
    ensure => present,
    owner  => 'root',
    group  => 'root',
    mode   => '0555',
    source => 'puppet:///modules/video/workers/get_stream_key.py',
  }

  file { '/usr/local/bin/get_lvs_stream_key.py':
    ensure => present,
    owner  => 'root',
    group  => 'root',
    mode   => '0555',
    source => 'puppet:///modules/video/workers/get_lvs_stream_key.py',
  }

  package { 'ffmpeg':
    ensure  => present
  }


  $ingest_disasterrecovery = 'ingest-disasterrecovery.justin.tv'

  $video = '/opt/twitch/videosource/playlist2.txt'

  $daemon = [
    '/usr/bin/ffmpeg',
    '-re',
    '-f', 'concat',
    '-safe', '0',
    '-i', "${video}",
    '-c', 'copy',
    '-f', 'flv',
    "rtmp://${ingest_disasterrecovery}/app/\$STREAM_KEY",
    '2>&1',
  ]


  video::workers::teststream_daemon{ 'twitchmedia_x2_cmh01_test':
    daemon     => [
      '/usr/bin/ffmpeg',
      '-re',
      '-i', '/opt/twitch/videosource/MERGED-1080p60-x264-6mbs.mp4',
      '-c', 'copy',
      '-f', 'flv',
      "rtmp://${ingest_disasterrecovery}/app/\$STREAM_KEY",
      '2>&1',
    ],
    channel_id => '416798181',
  }

  video::workers::teststream_daemon{ 'twitchmedia_ev_cmh01_test':
    daemon     => [
      '/usr/bin/ffmpeg',
      '-re',
      '-i', '/opt/twitch/videosource/MERGED-1080p60-x264-6mbs.mp4',
      '-c', 'copy',
      '-f', 'flv',
      "rtmp://${ingest_disasterrecovery}/app/\$STREAM_KEY",
      '2>&1',
    ],
    channel_id => '426660606',
  }

  video::workers::teststream_daemon{ 'twitchmedia_qs_cmh01_test':
    daemon     => [
      '/usr/bin/ffmpeg',
      '-re',
      '-i', '/opt/twitch/videosource/MERGED-1080p60-x264-6mbs.mp4',
      '-c', 'copy',
      '-f', 'flv',
      "rtmp://${ingest_disasterrecovery}/app/\$STREAM_KEY",
      '2>&1',
    ],
    channel_id => '426662991',
  }
  video::workers::teststream_daemon{ 'dr_cmh01_lvs_test':
    daemon    =>  [
      '/usr/bin/ffmpeg',
      '-re',
      '-f', 'concat',
      '-safe', '0',
      '-i', '/opt/twitch/videosource/playlist1080-60.txt',
      '-c', 'copy',
      '-f', 'flv',
      "rtmp://${ingest_disasterrecovery}/app/\$STREAM_KEY",
      '2>&1',
    ],
    predaemon => "STREAM_KEY=\$(/usr/local/bin/get_lvs_stream_key.py dr_cmh01_lvs_test)"
  }

}
