# contains all the teststreams that should exist in our system
class video::workers::twitchmediastreams1 {
  file { '/usr/local/bin/get_stream_key.py':
    ensure => present,
    owner  => 'root',
    group  => 'root',
    mode   => '0555',
    source => 'puppet:///modules/video/workers/get_stream_key.py',
  }

  package { 'ffmpeg':
    ensure  => present
  }

  video::workers::teststream{ 'twitchmediaus':
    channel_id => '58241318',
  }

  video::workers::teststream{ 'twitchmediaeu':
    channel_id => '58241266',
  }

  video::workers::teststream{ 'twitchmediasea':
    channel_id => '67680088',
  }

  video::workers::teststream{ 'qa_base_av_profile':
    channel_id => '99771711',
    res        => '1280x720',
    tags       => 'broadcast_tag=2015Baseline'
  }

  video::workers::teststream{ 'qa_beta_av_profile':
    channel_id => '99771590',
    res        => '1280x720',
    tags       => 'broadcast_tag=2015Main'
  }

  video::workers::teststream{ 'qa_nontranscode1':
    channel_id => '71776717',
  }

  video::workers::teststream{ 'qa_protected':
    channel_id => '71875230',
    res        => '1280x720'
  }

  video::workers::teststream{ 'qa_transcode1':
    channel_id => '71776568',
    res        => '1280x720'
  }

  video::workers::teststream{ 'twitchmedia1':
    channel_id => '87205166'
  }
  video::workers::teststream{ 'twitchmedia2':
    channel_id => '67679985'
  }
  video::workers::teststream{ 'twitchmedia3':
    channel_id => '84238108'
  }
  video::workers::teststream{ 'twitchmedia4':
    channel_id => '84238312'
  }
  video::workers::teststream{ 'twitchmedia5':
    channel_id => '87205300'
  }

}
