# Group 2 of Twitch Media test streams
class video::workers::twitchmediastreams2 {
  file { '/usr/local/bin/get_stream_key.py':
    ensure => present,
    owner  => 'root',
    group  => 'root',
    mode   => '0555',
    source => 'puppet:///modules/video/workers/get_stream_key.py',
  }

  file { '/usr/local/bin/get_lvs_stream_key.py':
    ensure => present,
    owner  => 'root',
    group  => 'root',
    mode   => '0555',
    source => 'puppet:///modules/video/workers/get_lvs_stream_key.py',
  }

  package { 'ffmpeg':
    ensure  => present
  }

  $ingest_live = 'live.twitch.tv'

  video::workers::teststream{ 'twitchmedia6':
    channel_id => '87205336'
  }
  video::workers::teststream{ 'twitchmedia7':
    channel_id => '87205419'
  }
  video::workers::teststream{ 'twitchmedia9':
    channel_id => '102931276'
  }
  video::workers::teststream{ 'twitchmedia10':
    channel_id => '102931304'
  }
  video::workers::teststream{ 'twitchmedia12':
    channel_id => '102931380'
  }
  video::workers::teststream{ 'twitchmedia13':
    channel_id => '102931539'
  }
  video::workers::teststream{ 'twitchmedia15':
    channel_id => '102931562'
  }

  video::workers::teststream_daemon{ 'im_ti6_1080res':
    daemon     => [
      '/usr/bin/ffmpeg',
      '-re',
      '-f', 'concat',
      '-safe', '0',
      '-i', '/opt/twitch/videosource/playlist1080-60.txt',
      '-c', 'copy',
      '-f', 'flv',
      "rtmp://${ingest_live}/app/live_127332409_5WA4DydPiWDS3caZT0oTxDDvVEi8T4?broadcast_tag=2016-1080-Res",
      '2>&1',
    ],
    channel_id => '127332409'
  }

  video::workers::teststream_daemon{ 'im_ti6_1080named':
    daemon     => [
      '/usr/bin/ffmpeg',
      '-re',
      '-f', 'concat',
      '-safe', '0',
      '-i', '/opt/twitch/videosource/playlist1080-60.txt',
      '-c', 'copy',
      '-f', 'flv',
      "rtmp://${ingest_live}/app/live_127332240_NhMaNpgotLJ5rymMdFqeJh1lEMfsr8?broadcast_tag=2016-1080-Named",
      '2>&1',
    ],
    channel_id => '127332240'
  }

  video::workers::teststream_daemon{ 'twitchmedia_lvs_live':
    daemon    =>  [
      '/usr/bin/ffmpeg',
      '-re',
      '-f', 'concat',
      '-safe', '0',
      '-i', '/opt/twitch/videosource/playlist1080-60.txt',
      '-c', 'copy',
      '-f', 'flv',
      "rtmp://${ingest_live}/app/\$STREAM_KEY",
      '2>&1',
    ],
    predaemon => "STREAM_KEY=\$(/usr/local/bin/get_lvs_stream_key.py twitchmedia_lvs_live)",
  }



}
