# Group 3 of Twitch Media test streams
class video::workers::twitchmediastreams3 inherits video::workers::params {
  $twitchmedia_ingest_addr = $video::workers::params::twitchmedia_ingest_addr

  file { '/usr/local/bin/get_stream_key.py':
    ensure => present,
    owner  => 'root',
    group  => 'root',
    mode   => '0555',
    source => 'puppet:///modules/video/workers/get_stream_key.py',
  }

  package { 'ffmpeg':
    ensure  => present
  }

  video::workers::teststream{ 'twitchmedia16':
    channel_id => '102931584'
  }
  video::workers::teststream{ 'twitchmedia17':
    channel_id => '102931643'
  }
  video::workers::teststream{ 'twitchmedia18':
    channel_id => '102931781'
  }
  video::workers::teststream{ 'twitchmedia19':
    channel_id => '102931859'
  }
  video::workers::teststream{ 'twitchmedia20':
    channel_id => '102931890'
  }
  video::workers::teststream{ 'twitchmedia21':
    channel_id => '102931908'
  }
  video::workers::teststream{ 'twitchmedia22':
    channel_id => '102931923'
  }
  video::workers::teststream{ 'twitchmedia23':
    channel_id => '102931952'
  }
  video::workers::teststream{ 'twitchmedia24':
    channel_id => '102931966'
  }

  # 300kbps 10sec keyframe interval stream
  video::workers::teststream_daemon{ 'twitchmedia_rv2_01':
    daemon     => [
      '/usr/bin/ffmpeg',
      '-re',
      '-i', '/opt/twitch/videosource/MERGED-1080p60-x264-6mbs.mp4',
      '-c', 'copy',
      '-f', 'flv',
      "rtmp://${twitchmedia_ingest_addr}/app/\$STREAM_KEY",
      '2>&1',
    ],
    channel_id => '146077050'
  }

  # 4K stream
  video::workers::teststream_daemon{ 'twitchmedia_rv2_08':
    daemon     => [
      '/usr/bin/ffmpeg',
      '-re',
      '-f', 'concat',
      '-safe', '0',
      '-i', '/opt/twitch/videosource/playlist_4K.txt',
      '-c', 'copy',
      '-f', 'flv',
      "rtmp://${twitchmedia_ingest_addr}/app/\$STREAM_KEY",
      '2>&1',
    ],
    channel_id => '147568181'
  }

  # long perf test stream
  video::workers::teststream_daemon{ 'twitchmedia_perf_01':
    daemon     => [
      '/usr/bin/ffmpeg',
      '-re',
      '-f', 'concat',
      '-safe', '0',
      '-i', '/opt/twitch/videosource/playlist1080-60.txt',
      '-c', 'copy',
      '-f', 'flv',
      "rtmp://${twitchmedia_ingest_addr}/app/\$STREAM_KEY",
      '2>&1',
    ],
    channel_id => '157918299'
  }

  # SCTE-35 stream, ffmpeg mangles the onCuePoints in this file
  video::workers::teststream_daemon{ 'twitchmedia_scte35':
    daemon     =>  [
      '/opt/twitch/videosource/bin/rtmppusher',
      '-filename', '/opt/twitch/videosource/elemental_scte_loop.flv',
      '-rtmp', "rtmp://${twitchmedia_ingest_addr}/app/\$STREAM_KEY",
      '2>&1',
    ],
    channel_id => '478617636',
  }

}
