# Group 4 of Twitch Media test streams (These are STAGING streams. Please put all staging streams here)
class video::workers::twitchmediastreams4 {
  file { '/usr/local/bin/get_stream_key.py':
    ensure => present,
    owner  => 'root',
    group  => 'root',
    mode   => '0555',
    source => 'puppet:///modules/video/workers/get_stream_key.py',
  }

  file { '/usr/local/bin/get_lvs_stream_key.py':
    ensure => present,
    owner  => 'root',
    group  => 'root',
    mode   => '0555',
    source => 'puppet:///modules/video/workers/get_lvs_stream_key.py',
  }

  package { 'ffmpeg':
    ensure  => present
  }


  $ingest_staging = 'ingest-staging.justin.tv'
  $video = '/opt/twitch/videosource/playlist2.txt'
  $daemon = [
    '/usr/bin/ffmpeg',
    '-re',
    '-f', 'concat',
    '-safe', '0',
    '-i', "${video}",
    '-c', 'copy',
    '-f', 'flv',
    "rtmp://${ingest_staging}/app/\$STREAM_KEY",
    '2>&1',
  ]

  video::workers::teststream_daemon{ 'twitchmedia_qs_1':
    daemon     => $daemon,
    channel_id => '118353338',
  }

  video::workers::teststream_daemon{ 'twitchmedia_qs_2':
    daemon     => $daemon,
    channel_id => '118353390',
  }

  video::workers::teststream_daemon{ 'twitchmedia_qs_3':
    daemon     => $daemon,
    channel_id => '118353443',
  }

  video::workers::teststream_daemon{ 'twitchmedia_qs_10':
    daemon     => $daemon,
    channel_id => '118353866',
  }

  video::workers::teststream_daemon{ 'twitchmedia_gblocktest':
    daemon     => $daemon,
    channel_id => '163120057',
  }


  # 60fps transcode
  video::workers::teststream_daemon{ 'twitchmedia_rv2_02':
    daemon     => [
      '/usr/bin/ffmpeg',
      '-re',
      '-i', '/opt/twitch/videosource/MERGED-1080p60-x264-6mbs.mp4',
      '-c', 'copy',
      '-f', 'flv',
      "rtmp://${ingest_staging}/app/\$STREAM_KEY?broadcast_tag=2017TranscodeQS",
      '2>&1',
    ],
    channel_id => '146077409',
  }

  video::workers::teststream_daemon{ 'twitchmedia_justverizon':
    daemon     => [
      '/usr/bin/ffmpeg',
      '-re',
      '-i', '/opt/twitch/videosource/nioh1440p60.mp4',
      '-c', 'copy',
      '-f', 'flv',
      "rtmp://live.twitch.tv/app/\$STREAM_KEY",
      '2>&1',
    ],
    channel_id => '198019100',
  }


  video::workers::teststream_daemon{ 'twitchmedia_rv2_05':
    daemon     => [
      '/usr/bin/ffmpeg',
      '-re',
      '-i', '/opt/twitch/videosource/nioh1440p60.mp4',
      '-c', 'copy',
      '-f', 'flv',
      "rtmp://${ingest_staging}/app/\$STREAM_KEY?broadcast_tag=2017TranscodeQS",
      '2>&1',
    ],
    channel_id => '146078903',
  }

  video::workers::teststream_daemon{ 'twitchmedia_lvs_staging':
    daemon    =>  [
      '/usr/bin/ffmpeg',
      '-re',
      '-f', 'concat',
      '-safe', '0',
      '-i', '/opt/twitch/videosource/playlist1080-60.txt',
      '-c', 'copy',
      '-f', 'flv',
      "rtmp://${ingest_staging}/app/\$STREAM_KEY",
      '2>&1',
    ],
    predaemon => "STREAM_KEY=\$(/usr/local/bin/get_lvs_stream_key.py twitchmedia_lvs_staging)"
  }

}
