class video::workers::usher_slab_reallocator {

  file { '/usr/local/bin/usher_slab_reallocator.pl':
    ensure => present,
    owner  => 'root',
    group  => 'root',
    mode   => '0555',
    source => 'puppet:///modules/video/workers/usher_slab_reallocator.pl',
  }

  daemontools::supervise{ 'usher_slab_reallocator':
    wd      => '/tmp/',
    daemon  => '/usr/local/bin/usher_slab_reallocator.pl --host localhost:11211',
    user    => 'nobody',
    require => File['/usr/local/bin/usher_slab_reallocator.pl'],
  }
}
