# defines sdk metric ingest to cloudwatch.
class video_cloudwatch::csm (
  $ensure       = $video_cloudwatch::params::ensure,
  $csm_clientid = $video_cloudwatch::params::csm_clientid,
  $memory_limit = 20,
  $port         = 31000,
) inherits video_cloudwatch::params {
  include video_cloudwatch

  $config = {
    'csm' => {
      'memory_limit_in_mb' => $memory_limit,
      'port' => $port,
    }
  }

  $rsrc_ensure = $ensure ? {
    'absent' => 'absent',
    default  => 'present',
  }

  # listen for sdk metrics.
  file { "${video_cloudwatch::params::config_dir}/conf.d/csm.json":
    ensure  => $rsrc_ensure,
    content => consul_sorted_json($config, true, 2),
    notify  => Service['amazon-cloudwatch-agent'],
  }

  # emit metrics from my sdk
  twitch_systemd::drop_in { 'csm.conf':
    ensure  => $rsrc_ensure,
    unit    => 'amazon-cloudwatch-agent.service',
    content => template("${module_name}/csm.dropin.erb"),
    manage  => false,
    notify  => Service['amazon-cloudwatch-agent'],
  }
}
