# defines emf ingest to cloudwatch logs.
class video_cloudwatch::emf (
  $ensure           = $video_cloudwatch::params::ensure,
) inherits video_cloudwatch::params {
  include video_cloudwatch

  $config = {
    'logs' => {
      'metrics_collected' => {
        'emf' => { }
      }
    }
  }

  file { "${video_cloudwatch::params::config_dir}/conf.d/emf.json":
    ensure  => $ensure ? { 'absent' => 'absent', default => 'present' },
    content => consul_sorted_json($config, true, 2),
    notify  => Service['amazon-cloudwatch-agent'],
  }
}
