# Installs and manages config of video's cloudwatch agent config
class video_cloudwatch (
  $ensure       = $video_cloudwatch::params::ensure,
) inherits video_cloudwatch::params {

  package { 'amazon-cloudwatch-agent':
    ensure => $ensure,
  }

  package { 'video-cloudwatch-agent':
    ensure  => $ensure,
    require => Package['amazon-cloudwatch-agent'],
  }

  if $ensure == 'absent' {
    $service_ensure = 'stopped'
    $service_enable = false
    $dir_ensure     = 'absent'
  } else {
    $service_ensure = 'running'
    $service_enable = true
    $dir_ensure     = 'directory'
  }

  file { 'agent_config_dir':
    ensure  => $dir_ensure,
    path    => "${video_cloudwatch::params::config_dir}/conf.d",
    require => Package['video-cloudwatch-agent'],
  }

  service { 'amazon-cloudwatch-agent':
    ensure  => $service_ensure,
    enable  => $service_enable,
    require => [File['agent_config_dir'], Package['amazon-cloudwatch-agent']],
  }

}
