# defines a logfile to ingest to cloudwatch logs.
define video_cloudwatch::logfile (
  $ensure           = 'present',
  $file_path        = "/var/log/jtv/${title}.log",
  $log_group_name   = "/vidcs/${title}",
  $log_stream_name  = $::pqdn,
  $timestamp_format = '%b %-d %H:%M:%S',
  $timezone         = 'Local',
) {
  include video_cloudwatch

  validate_re($timezone,['^Local$', '^UTC$'])

  $config = {
    'logs' => {
      'logs_collected' => {
        'files' => {
          'collect_list' => [
            {
              'file_path'        => $file_path,
              'log_group_name'   => $log_group_name,
              'log_stream_name'  => $log_stream_name,
              'timestamp_format' => $timestamp_format,
              'timezone'         => $timezone,
            }
          ]
        }
      }
    }
  }

  file { "${video_cloudwatch::params::config_dir}/conf.d/${title}.json":
    ensure  => $ensure,
    content => consul_sorted_json($config, true, 2),
    notify  => Service['amazon-cloudwatch-agent'],
  }
}
