# defines a statsd listener for the cloudwatch agent.
define video_cloudwatch::statsd (
  $ensure               = 'present',
  $listen_on            = '127.0.0.1',
  $port                 = '8125',
  $collection_interval  = 10,
  $aggregation_interval = 60,
) {
  include video_cloudwatch

  $config = {
    'metrics' => {
      'metrics_collected' => {
        'statsd' => {
          'service_address'              => "${listen_on}:${port}",
          'metrics_collection_interval'  => $collection_interval,
          'metrics_aggregation_interval' => $aggregation_interval,
        }
      }
    }
  }

  file { "${video_cloudwatch::params::config_dir}/conf.d/${title}.json":
    ensure  => $ensure,
    content => consul_sorted_json($config, true, 2),
    notify  => Service['amazon-cloudwatch-agent'],
  }
}
