class video_tier1::params {
  $consul_tags         = []
  $use_cloudwatch      = true
  $frontier_transition = false
  $varnish_release     = '4.1'
  $varnish_pop         = $::pop
  $nginx_reload        = str2bool($::systemd) ? {
    true    => 'sudo systemctl reload nginx',
    default => 'sudo /etc/init.d/nginx reload'
  }

  $varnish_daemon_params = {
    'timeout_idle'        => 60,
    'send_timeout'        => 60,
    'idle_send_timeout'   => 60,
    'thread_pool_min'     => 100,
    'thread_pool_max'     => 4000,
    'thread_pool_timeout' => 300,
    'cli_timeout'         => 60,
    'thread_pools'        => 2,
  }
}
