# video_tools_staged_deploy ensures that the latest versions of the
# sd2-deployment-daemon and any other Staged Deploy packages are installed and
# running. Currently it only manages the sd2-deployment-daemon package

# Defaults to ensuring the `latest` version.
class video_tools_staged_deploy (
  $version = $video_tools_staged_deploy::params::version,
  $ensure  = $video_tools_staged_deploy::params::ensure,
) inherits video_tools_staged_deploy::params {

  require twitch_amazon_ssm_agent
  require milliner

  # Set the package ensure parameter to absent or the version provided.
  case $ensure {
    present: {
      $ensure_pkg = $version
      $enable_chk = true
    }
    default: {
      $ensure_pkg = absent
      $enable_chk = false
    }
  }

  # add packages
  package { 'sd2-deployment-daemon':
    ensure      => $ensure_pkg,
    configfiles => 'replace',
  }

  # Using Unattended-Upgrade::Package-Whitelist causes all other packages to
  # not update. Use a cronjob instead. Delete this once all hosts run puppet
  # agent on a schedule.
  cron::job { 'sd2-deployment-daemon':
    ensure      => 'present',
    command     => 'apt-get install -y sd2-deployment-daemon >/dev/null 2>&1',
    user        => 'root',
    environment => [
      'DEBIAN_FRONTEND=noninteractive',
      'PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin:/usr/local/sbin',
    ],
    minute      => fqdn_rand(59, $title),
    hour        => fqdn_rand(23, $title),
  }

  # Create a check to forward sd2-deployment-daemon health status to nagios.
  if $enable_check {
    twitch_servicecheck::passive { 'sd2-deployment-daemon-health-check':
      command        => '/opt/twitch/staged-deploy-2/bin/sd2-health_check',
      interval       => 60, # minutes between checks
      retry          => 1, # times to fail before reporting failure
      retry_interval => 60, # minutes between checks once reporting failure
    }
  }
}
