#!/bin/bash
set -eu -o pipefail

consul_check_url="http://localhost:8500/v1/agent/checks"
status_output=$(/usr/bin/curl --silent --max-time 15 "$consul_check_url")

node_status=$(echo $status_output | /usr/bin/jq --raw-output '.["node-enabled"].Status')
service_status=$(echo $status_output | /usr/bin/jq --raw-output '.["service:video-weaver-lb"].Status')

node_enabled=""
service_enabled=""

test "$node_status" = "passing" && node_enabled="enabled"
test "$service_status" = "passing" && service_enabled="enabled"

STATUS=1
MSG="UNKNOWN: node-enabled is UNKNOWN\nUNKNOWN: service:video-weaver-lb is UNKNOWN"

if [ "$node_enabled" ] && [ "$service_enabled" ]; then
  STATUS=0
  MSG="OK: node-enabled is PASSING\nOK: service:video-weaver-lb is PASSING"
elif [ "$service_enabled" ]; then
  STATUS=1
  MSG="WARNING: node-enabled is FAILING\nOK: service:video-weaver-lb is PASSING"
elif [ "$node_enabled" ]; then
  STATUS=2
  MSG="OK: node-enabled is PASSING\nCRIT: service:video-weaver-lb is FAILING"
fi

echo -e $MSG
exit $STATUS
