define video_weaver_lb::anycast_instance (
  $bgp_announce,
  $bgp_community,
  $interface = 'lo',
) {
  # To make things easier, parse out the ip address from the announce.
  $address = $bgp_announce ? {
    /^(.+)\/.+$/ => "$1",
  }

  validate_string($name)
  validate_ip_address($address)

  bird::loopback { "${interface}:${name}":
    ipaddress => $address
  }

  $twitch_basedir = hiera('twitch_basedir','/opt/twitch')
  $script_name    = 'consul_health_check.sh'
  $app_dir        = "${twitch_basedir}/anycast_health_enforcer"

  file { "${app_dir}/${script_name}":
    source => "puppet:///modules/${module_name}/${script_name}",
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  # TODO: Add nagios passive check
  twitch_anycast::health_enforcer::daemon { "${interface}:${name}":
    check_command => "${app_dir}/${script_name}",
    require       => File["${app_dir}/${script_name}"],
  }
}
