class video_weaver_lb (
  $consul_service = $video_weaver_lb::params::consul_service,
  $consul_env     = $video_weaver_lb::params::consul_env,
  $haproxy_checks = $video_weaver_lb::params::haproxy_checks,
  $anycast        = undef,
) inherits video_weaver_lb::params {
  validate_hash($anycast)

  class { 'twitch::haproxy::video_weaver_lb': }

  consul::service { $consul_service:
    service_name   => $consul_service,
    consul_tags    => [ $consul_env ],
    check_http     => 'http://127.0.0.1/health',
    check_interval => '5s',
  }

  class { 'bird':
    protocol => 'bgp',
  }

  class { 'twitch_cosmos':
    ensure               => 'present',
    node_type            => 'weaver_lb',
    haproxy_sockets_path => '/var/run/haproxy-video_weaver_lb-stats.*.sock',
  }

  bird::daemon { 'weaver_lb':
    instances => values($anycast),
  }

  create_resources(video_weaver_lb::anycast_instance, $anycast)

  include twitch_nrdp
  realize(Twitch_nrdp::Check['check_aes'])

  if $consul_env == 'production' {
    twitch_nrdp::check { 'weaver-lb_haproxy_stats':
      command  => "check_haproxy_stats.py -s '/var/run/' -g 'haproxy-video_weaver_lb*.sock' -c ${haproxy_checks}",
      interval => 1,
      retry    => 3,
    }
  }
}
