# The vtp_ssm_sidecar class, when activated, defaults to ensuring the `latest` version
# of the vtp-ssm-sidecar package is installed.
#
# To remove the vtp-ssm-sidecar package give `absent` for the ensure param, run
# puppet, and then remove the vtp_ssm_sidecar class from the list of classes in the
# hiera spec.
class vtp_ssm_sidecar (
  $ensure  = $vtp_ssm_sidecar::params::ensure,
  $version = $vtp_ssm_sidecar::params::version,
) inherits vtp_ssm_sidecar::params {

  require twitch_amazon_ssm_agent

  # Set the package ensure parameter to absent or the version provided.
  case $ensure {
    'present': {
      $ensure_pkg = $version
      $enable_check = true
    }
    'absent': {
      $ensure_pkg = 'absent'
      $enable_check = false
    }
    default: {
      fail('vtp_ssm_sidecar::ensure must be present or absent')
    }
  }

  package { 'vtp-ssm-sidecar':
    ensure      => $ensure_pkg,
    configfiles => 'replace',
  }

  # Create a check to forward vtp_ssm_sidecar health status to nagios.
  if $enable_check {
    twitch_servicecheck::passive { 'vtp-ssm-sidecar-token-check':
      command        => '/usr/local/bin/mck',
      interval       => 60, # minutes between checks
      retry          => 1, # times to fail before reporting failure
      retry_interval => 60, # minutes between checks once reporting failure
    }
  }
}
