define watcher::nginx_logstats::watch (
  $access_log_prefix,
  $graphite_host,
) {
  $logfile  = "/var/log/nginx/$access_log_prefix.access.log"
  $prefix   = "stats.nginx.$hostname.$name.response"
  $daemon   = "/usr/bin/nginx_logstats -prefix $prefix -log-file $logfile -server $graphite_host 2>&1"
  $svc_name = "nginx_logstats_$name"

  ::daemontools::supervise { $svc_name:
    syslog  => "local3",
    wd      => "/tmp",
    daemon  => $daemon,
    require => Package['nginx-logstats'],
  }
}
