class watcher::pg_stats(
  $enabled = true,
  $global_interval = undef,
  $go_max_procs = 2,
  $lag_interval = undef,
  # This parameter is here so we can install on machines without the
  # puppet labs module which provides postgresql-server regardless of
  # version. db class machines currently need to override this in hiera.
  $postgresql_package = 'postgresql-server',
  $schema,
  $stat_interval = undef,
  $statsd_addr = 'graphite-ingest.central.twitch.a2z.com:8125',
  $version = '0.3.8',
) inherits watcher {
  validate_bool($enabled)

  # The pg-stats package can be found at
  # https://git-aws.internal.justin.tv/d8a/pg-stats
  package { 'pg-stats':
    ensure  => $version,
    # Not strictly true that we need postgresql-server. Configured
    # this way so we can use the postgres user locally and avoid
    # password configuration winding up everywhere.
    require => Package[$postgresql_package],
  }

  $global = $global_interval ? {
    undef => '',
    default => " -global-interval=${global_interval}",
  }
  $lag = $lag_interval ? {
    undef => '',
    default => " -lag-interval=${lag_interval}",
  }
  $stat = $stat_interval ? {
    undef => '',
    default => " -stat-interval=${stat_interval}",
  }
  $args = "-cluster=${cluster} -server=${statsd_addr} -schema=${schema}${global}${lag}${stat} -hostname=${hostname}"
  $daemon = "/usr/bin/pg-stats ${args} 2>&1"

  $down = $enabled ? {
    false => 'force',
    true  => 'false',
  }
  ::daemontools::supervise { 'pg-stats':
    daemon     => $daemon,
    daemon_dir => '/var/lib/service',
    down       => $down,
    require    => Package['pg-stats'],
    subscribe  => Package['pg-stats'],
    syslog     => 'local3',
    user       => 'postgres',
    wd         => '/tmp',
    predaemon  => [
      "export GOMAXPROCS=${go_max_procs}",
    ]
  }

}
