class watcher::pgbouncer_stats(
  $enabled = true,
  $go_max_procs = 2,
  $ports,
  $statsd_addr = 'graphite-ingest.central.twitch.a2z.com:8125',
  $version = 'latest',
) inherits watcher {
  validate_bool($enabled)
  validate_array($ports)

  # The pgbouncer-stats package can be found at
  # https://git-aws.internal.justin.tv/d8a/pgbouncer-stats
  package { 'pgbouncer-stats':
    ensure => $version
  }

  $pg_ports = prefix($ports, '-port ')
  $cl_ports = join($pg_ports, " ")
  $daemon   = "/usr/bin/pgbouncer-stats -cluster $hostname -server $statsd_addr $cl_ports 2>&1"

  $down = $enabled ? {
    false => 'force',
    true  => 'false',
  }
  ::daemontools::supervise { 'pgbouncer-stats':
    daemon     => $daemon,
    daemon_dir => '/var/lib/service',
    down       => $down,
    require    => Package['pgbouncer-stats'],
    subscribe  => Package['pgbouncer-stats'],
    user       => 'postgres',
    syslog     => 'local3',
    wd         => '/tmp',
    predaemon  => [
      "export GOMAXPROCS=${go_max_procs}",
    ],
  }
}
