define watcher::varnish_stats::watch (
  $graphite_host,
) {
  $prefix   = "stats.varnish.$hostname"
  $daemon   = "/usr/bin/varnish-stats -prefix $prefix -server $graphite_host 2>&1"
  $svc_name = "varnish-stats_$name"

  ::daemontools::supervise { $svc_name:
    syslog     => "local3",
    wd         => "/tmp",
    daemon     => $daemon,
    require    => Package['varnish-stats'],
    subscribe  => Package['varnish-stats'],
    daemon_dir => '/var/lib/service'
  }
}
