class weaver::params {
  $ensure                = 'present'

  $primary_public_addr   = ':6000'
  $primary_private_addr  = ':7000'
  $backup_public_addr    = ':6001'
  $backup_private_addr   = ':7001'

  $env                   = 'production'

  $gogc                  = 1000
  $godebug               = ''

  $statsd_host           = hiera('statsd_host', 'statsd.internal.justin.tv')
  $statsd_port           = hiera('statsd_port', 8125)
  $statsd_rate           = undef
  $statsd_addr           = "${statsd_host}:${statsd_port}"
  $statsd_type           = "weaver"

  $usher_url             = "http://video-api.internal.justin.tv"
  $upstream_url          = "http://localhost/upstream"

  $ads_ehrmantraut       = undef
  $ads_fring             = undef
  $ad_concurrency_limit  = undef


  $sandstorm_prefix      = ''
  $aws_access_key_path   = '/etc/default/weaver'

  $basedir               = '/opt/twitch'
  $project               = 'video/weaver'

  $redis_protocol        = 'unix'
  $redis_address         = '/var/run/redis/redis_weaver.sock'
  $redis_cluster         = false

  $haproxy_checks        = 'conn-ratio sess-ratio instance-status available-backend'
  $haproxy_checks_enable = true
  $server_status         = false


  $redis_cluster_options = {
    "usesocket"      => false,
    "manage_service" => false,
    "cluster_mode"   => true,
    "save"           => [ '""' ], # no saving
  }

  $beacon_url            = undef

  $enable_longpoll       = true

  $gatekeeper_library    = true
  $gatekeeper_fqdn       = undef
  $gatekeeper_name       = undef

  $rubick_masters        = 8
  $rubick_replicas       = 8
}
