define weaver::redis_cluster_instance(
  $default_options,
  $consul_tags,
  $ensure = present,
) {

  $_split_name   = split($name, '-')
  $port          = $_split_name[1] + 0 # turn into FixedNum
  $instance_name = regsubst($name, '-', '_', 'G')

  validate_integer($port)

  # structure for `create_resources()`
  $redis_instance = {
    "$instance_name" => {
      ensure => $ensure,
      bind   => [ $::ipaddress_primary, '127.0.0.1' ],
      port   => $port,
    }
  }

  create_resources(twitch_redis::server, $redis_instance, $default_options)

  consul::service { "weaver_redis_${port}":
    ensure       => $ensure,
    service_name => 'video-weaver-redis',
    consul_tags  => $consul_tags,
    port         => $port,
  }
}
