c1 = 0xcc9e2d51;
c2 = 0x1b873593;


"""Murmurhash v3 (r136) implementation. Takes a string key and an
integer seed and produces a 32-bit hash, returned as an int."""
def murmurhash(key, seed):
    remainder = len(key) % 4
    nbytes = len(key) - remainder

    h1 = seed
    i = 0

    k1 = 0
    while i < nbytes:
        k1 = (ord(key[i]) & 0xFF |
              ((ord(key[i+1]) & 0xFF) << 8) |
              ((ord(key[i+2]) & 0xFF) << 16) |
              ((ord(key[i+3]) & 0xFF) << 24))
        i += 4
        k1 = ((((k1 & 0xffff) * c1) + ((((k1 >> 16) * c1) & 0xffff) << 16))) & 0xffffffff
        k1 = (k1 << 15) | (k1 >> 17)
        k1 = ((((k1 & 0xffff) * c2) + ((((k1 >> 16) * c2) & 0xffff) << 16))) & 0xffffffff

        h1 ^= k1
        h1 = (h1 << 13) | (h1 >> 19)
        h1b = ((((h1 & 0xffff) * 5) + ((((h1 >> 16) * 5) & 0xffff) << 16))) & 0xffffffff
        h1 = (((h1b & 0xffff) + 0x6b64) + ((((h1b >> 16) + 0xe654) & 0xffff) << 16))

    k1 = 0
    if remainder == 3:
        k1 = ((ord(key[i+2]) & 0xff) << 16)
    if remainder >= 2:
        k1 ^= ((ord(key[i+1]) & 0xff) << 8)
    if remainder >= 1:
        k1 ^= ((ord(key[i]) & 0xff))
        k1 = (((k1 & 0xffff) * c1) + ((((k1 >> 16) * c1) & 0xffff) << 16)) & 0xffffffff;
        k1 = (k1 << 15) | (k1 >> 17);
        k1 = (((k1 & 0xffff) * c2) + ((((k1 >> 16) * c2) & 0xffff) << 16)) & 0xffffffff;
        h1 ^= k1;

    h1 ^= len(key)
    h1 ^= h1 >> 16

    h1 = (((h1 & 0xffff) * 0x85ebca6b) + ((((h1 >> 16) * 0x85ebca6b) & 0xffff) << 16)) & 0xffffffff;
    h1 ^= h1 >> 13;
    h1 = ((((h1 & 0xffff) * 0xc2b2ae35) + ((((h1 >> 16) * 0xc2b2ae35) & 0xffff) << 16))) & 0xffffffff;
    h1 ^= h1 >> 16;

    return h1 >> 0;


""" Uses murmurhash as the generating function for an RNG. """
def murmur_rand(key, seed):
    return murmurhash(key, seed) / float(0xFFFFFFFF)
