import signal
from contextlib import contextmanager


class TimeoutException(Exception):
    pass


@contextmanager
def timeout(timeout, msg=None):
    """executes fn, raising a TimeoutException unless fn completes within
    timeout seconds. Not thread-safe.

    if msg is callable, it will be evaluated, with no arguments, right
    before setting it as the value of the exception.

    """
    if msg is None: msg = "Timed out after %d seconds" % timeout

    def on_timeout(signum, frame):
        if callable(msg):
            message = msg()
        else:
            message = msg
        raise TimeoutException(message)

    signal.signal(signal.SIGALRM, on_timeout)
    signal.alarm(timeout)
    yield
    signal.alarm(0)
