#!/usr/bin/env python
from twisted.internet import reactor
from twisted.python import log, usage
import time, sys, os, traceback


from flvtools import flv
from flvtools.rtmp import amf_py as amf
from flvtools.factories import rtmp

import time, sys, os, traceback
import hmac, hashlib, re


streamId = 4
channelId = 4
start_time = 0
stream_name = None
success_flag = False
output = open('/dev/null')
last_tag_time = time.time()

def logstr(msg, level=1):
    if level < 2 and not options['verbose']:
        return
    log.msg(msg)
         
def connection_failed(result):
    logstr("Connection failed: args = %s" % result)
    os._exit(-1)

def connected(result, options):
    logstr("CONNECTED!  args = %s" % result, level=2)
    client.get_nc().server_bw('\x00\x13\x12\xd0')
    client.get_nc().invoke('createStream', streamId)
    client.get_nc().invoke('FCSubscribe', 0.0, stream_name, channel=amf.EVENT_CHANNEL);
    client.createStreamDeferred.addCallback(play, options)
    client.get_nc().ping('\x00\x03\x00\x00\x00\x00\x00\x00\x00d')

def play(result, options):
    if options['accesscode'] is not 'none':
        logstr('Sending password "%s"' % options['accesscode'])
        client.get_nc().invoke('NetStream.Authenticate.AccessCode', 0.0, options['accesscode'], insertNone=True, channel=amf.EVENT_CHANNEL)
    
    if options['secret_key'] is not 'none' and options['message'] is not 'none':
        logstr('Signing message %s with key %s...' % (options['message'], options['secret_key']))
        signed = '%s:%s' % (hmac.new(options['secret_key'], options['message'], hashlib.sha1).hexdigest(), options['message'])
        logstr('result: %s' % signed)
        client.get_nc().invoke('NetStream.Authenticate.UsherToken', 0.0, signed, insertNone=True, channel=amf.EVENT_CHANNEL)
    elif options['message'] is not 'none':
        logstr('Sending pre-signed message %s...' % options['message'])
        client.get_nc().invoke('NetStream.Authenticate.UsherToken', 0.0, options['message'], insertNone=True, channel=amf.EVENT_CHANNEL)

    logstr("STREAM CREATED!  Getting %s  args = %s" % (stream_name, result))
    logstr("Stream id is %s" % streamId)
    if streamId not in client.get_nc().streams:
        client.get_nc().create_netstream(streamId)
    client.get_nc().invoke('receiveVideo', 0.0, True, streamId=1)
    client.get_nc().invoke('receiveAudio', 0.0, True, streamId=1)
    client.get_nc().invoke('play', 0.0, [stream_name, -2000.0], streamId=1)
    client.get_nc().invoke('play', 0.0, [stream_name, -2000.0], streamId=result[3])
    client.get_nc().ping('\x00\x03\x00\x00\x00\x01\x00\x00\x00d')
    
def success(result, options):
    global streamId, start_time, client, success_flag
    logstr("SUCCESS! %s" % result)
    success_flag = True
    start_time = time.time()
    output.write(flv.writeHeader())
    logstr('Available netstream ids are: %s' % client.get_nc().streams.keys())
    client.get_nc().streams[streamId].stream = Processor(options)
    client.get_nc().streams[1].stream = Processor(options)
    client.get_nc().streams[0].stream = Processor(options)
    #start ping loop. This is NOT acomplished by the earlier ping calls, which go to the base class
    client.get_nc().ping()
    if options['exit']:
        logstr('Exiting now...')
        os._exit(0)
        
class AuthenticationHandler():
    
    def callback(self, args):
        logstr('Stream requires a password and you did not supply the correct one.')
        logstr(`args`)
        os._exit(-5)
            

format_logged = False
audio_format = None
video_format = None

class Processor:
    
    def __init__(self, opt = {}):
        self.options = opt
        self.count = 0
        self.key_count = 0
        self.started = False
        self.audio_tc = 0
        self.video_tc = 0
        if self.options.get('verbose'):
            self.verbose = True
        else:
            self.verbose = False
        
    def addPackets(self, packets):
        global start_time, output, client, last_tag_time, format_logged, audio_format, video_format
        last_tag_time = time.time()
        if self.verbose:
            logstr('Got %s packets' % len(packets))
        for tag in packets:
            if not format_logged:
                if tag['type'] == 8 and len(tag['data']) > 0 and not flv.isAudioConfig(tag):
                    audio_format = flv.getAudioCodec(tag)
                elif tag['type'] == 9 and len(tag['data']) > 0 and not flv.isVideoConfig(tag):
                    video_format = flv.getVideoCodec(tag)
                if (audio_format and video_format) or self.count > 100:
                    format_logged = True
                    logstr("Stream format: Video %s Audio %s"%(video_format, audio_format), level=2)
                
            if not len(tag['data']):
                if self.verbose:
                    logstr('empty packet of type %s' % tag['type'])
                    logstr(tag)
                continue
                
            if flv.isKeyframe(tag):
                if not flv.isVideoConfig(tag):
                    self.key_count  += 1
                if not self.started:
                    self.started = True
                    logstr('Got keyframe')
            elif not self.started:
                logstr('Waiting for first keyframe... this was a packet of type %s %s' % (tag['type'], flv.getVideoFrame(tag)))
            if self.started:
                tc = 0
                if tag['type'] == 8:
                    self.audio_tc += tag["timecode"]
                    tc = self.audio_tc
                if tag['type'] == 9:
                    self.video_tc += tag["timecode"]
                    tc = self.video_tc
                output.write(flv.writeTag(tag, tc))
                self.count += 1
            
            key_limit = self.options.get('keyframes', 'unlimited') 
            if key_limit != 'unlimited':
                if self.key_count >= int(key_limit):
                    logstr('DONE.  Read %s keyframes.' % self.key_count)
                    output.close()
                    os._exit(0)
                        
            tag_limit = self.options.get('packets', 'unlimited')
            if tag_limit != 'unlimited':
                if self.count >= int(tag_limit):
                    logstr('DONE.  Read %s packets.' % self.count)
                    output.close()
                    os._exit(0)
            
            length_limit = self.options.get('length', 'unlimited')
            if length_limit != 'unlimited' and self.started:
                if tc >= float(length_limit)*1000:
                    logstr('DONE.  Read %s packets.' % self.count)
                    output.close()
                    os._exit(0)
        logstr("add packets done")

def failure(result, options):
    logstr("FAILURE! %s" % result)
    description = results.value[-1]["description"]
    failed = False
    if 'nofollow' not in options:
        try:
            ip, port = description.split(" ")[-1].split(",")[0].split(":")
            logstr("Redirected to %s, port %s" % (ip, port))
            reactor.callLater(1.0, play_from, ip, port)
        except:
            failed = True
    if failed:
        os._exit(-2)
            
class fake_thing:
    def get_uptime(*args):
        return 1
        
    def plug(command, *args, **kwargs):
        logstr('Command: %s')
        logstr(repr(args))
        logstr(repr(kwargs))
        if command == 'invoke':
            logstr('Got an invoke!!!')
            return True

core = None

def make_core():
    global core
    core = fake_thing()
    core.config = {'max_conn_per_ip': 666, 'max_conn': 666}
    core.name = "fake"
    core.nodes = {core.name: fake_thing()}

client = None

def play_from(options):
    global client, core
    make_core()
    logstr("Connecting to %s:%s..." % (options['host'], options['port']))
    params = {'flashVer' : 'PMS'}
    client = rtmp.RTMPServer(core, 
        client=True, 
        app=options['app'], 
        tcUrl = options['rtmp_connect'], 
        swfUrl = options['swfurl'], 
        pageUrl = options['pageurl'], 
        params=params )
    client.connectDeferred.addCallbacks(connected, connection_failed, (options,))
    client.playDeferred.addCallback(success, options)
    client.otherDeferreds['NetStream.Authenticate.Failed'] = AuthenticationHandler()
    #client.playDeferred.addErrback(failure, options)
    reactor.connectTCP(options['host'], int(options['port']), client)

def pull(options):
    global stream_name
    stream_name = options['stream']
    play_from(options)
    
def timeout():
    global options
    if time.time() - last_tag_time > float(options['timeout']):
        logstr("Timeout fetching stream %s (%.2fs)" % (options['stream'], float(options['timeout'])))
        os._exit(-3)
    if options['abs_timeout']: 
        logstr("Absolute timeout fetching stream %s (%.2fs)" % (options['stream'], float(options['timeout'])))
        os._exit(0)
    reactor.callLater(5.0, timeout)
    

if __name__ == "__main__":
    class Options(usage.Options):
        optFlags = [
            ['verbose', 'v', 'Detailed logging'],
            ['exit', 'e', 'Exit on success'],
            ['nofollow', 'f', 'Do not follow redirects'],
            ['abs_timeout', 'b', 'Count timeout from start of call, rather than from last video frame'],
        ]
        optParameters = [
            ['stream', 's', 'stream_name', 'Stream name'],
            ['host', 'h', '127.0.0.1', 'RTMP server'],
            ['port', 'p', '1935', 'RTMP port'],
            ['output_file', 'o', '/dev/null', 'Output FLV file'],
            ['log', 'l', 'stdout', 'Log file'],
            ['keyframes', 'i', 'unlimited', 'Number of keyframes to capture'],
            ['packets', 'n', 'unlimited', 'Number of packets to capture'],
            ['length', 'g', 'unlimited', 'Length in seconds to capture'],
            ['swfurl', 'w', 'http://www.justin.tv/test.swf', 'swfUrl'],
            ['pageurl', 'W', 'http://justin.tv/justin', 'pageUrl'],
            ['app', 'a', 'app', 'Application name'],
            ['timeout', 't', 'none', 'Timeout in seconds (after last packet unless abs flag is set)'],
            ['accesscode', 'c', 'none', 'Stream access code'],
            ['secret_key', 'k', 'none', 'Secret access key for JTV auth'],
            ['message', 'm', 'none', 'Message to be signed by secret_key'],
            
        ]
    options = {}
    try:
        options = Options()
        options.parseOptions()
    except usage.UsageError, errortext:
        print '%s: %s' % (sys.argv[0], errortext)
        print '%s: Try --help for usage details.' % (sys.argv[0])
        sys.stdout.flush()
        sys.exit(-4)
    
    match = re.match(r"^rtmp://([^/]*)/([^/]*)", options['host'])
    if match:
        options['rtmp_connect'] = options['host']
        options['host'] = match.group(1)
        options['app'] = match.group(2)
    else:
        options['rtmp_connect'] = "rtmp://%s/%s" % (options['host'],options['app']) 
        
    if options['output_file'] != '-':
        output = open(options['output_file'], "w")
    else:
        #redirect out to stdout and loggin to /dev/null
        output = sys.stdout
        sys.stdout = open('/dev/null', 'w')
            
    
    if options['log'] == 'stdout':
        l = sys.stdout
    else:
        l = open(options['log'], 'w')
    log.startLogging(l)
        
    pull(options)
    if options['timeout'] != 'none':
        reactor.callLater(float(options['timeout']), timeout)
    reactor.run()
