#!/usr/bin/env python
from twisted.internet import reactor
from twisted.python import log, usage
from flvtools import flv, connection
from flvtools.factories import rtmp
import time, sys, os, httplib, struct
import simplejson, traceback, random

from flvtools.rtmp import amf_py as amf


import hmac, hashlib


streamId = 4
channelId = 4
broadcast_stream_id = 1.0 



file = None

stream_play = None
stream_token = None

node_name = None
tags_sent = []
push_start_time = 0
push_last_time_stamp = 0

tags_received = []
pull_start_time = 0

options = {}

push_success_flag = False
pull_success_flag = False

def rand_string(l):
    rtn = ""
    for i in range(l):
        rtn += chr(random.randint(0, 255))
    return rtn

def fake_flv_genorator(bitrate = 500000.0,  length = 60.0, framerate = 30.0, key_int = 5.0, key_to_i_ratio = 9.5):
    "produce a simulated vp6 flv file"
    key_size = (bitrate  / (1/key_int + framerate/key_to_i_ratio - 1/(key_int * key_to_i_ratio)))/ 8.0
    i_size = key_size / key_to_i_ratio
    t = 0
    
    while True:
        if t % (key_int*framerate) == 0:
            #key frame
            data = '\x14\x00' + rand_string(key_size - 2)
        else:
            data = '\x24\x00' + rand_string(i_size - 2)
        
        time_stamp = (t/framerate)*1000
    
        yield {'data':data, 'type':9, 'time_stamp': time_stamp}
    
        if time_stamp >= length*1000:
            return 
        t += 1
     


###
#
# flvpusher
#
##

def push_connected(*args):
    global streamId
    log.msg(" PUSH CONNECTED! args = %s" % args)
    push_client.invoke('createStream', streamId)
    push_client.createStreamDeferred.addCallback(push_publish)

def push_publish(*args):
    global options
    
    log.msg("PUSH STREAM CREATED! args = %s" % args)
    
    push_client.invoke('publish', 0.0, [options['stream'], 'live'], streamId=broadcast_stream_id)
    push_client.publishDeferred.addCallback(push_publishing)

def push_publishing(*args):
    global file, push_start_time, push_success_flag
    push_success_flag = True
    log.msg("PUSH PUBLISHING %s to %s - args = %s" % (file, options['stream'], args))
    if file == 'auto':
        tag_gen = fake_flv_genorator()
    else:
        tag_gen = flv.readFile(open(file, 'r'))
    push_start_time = time.time()
    reactor.callLater(0, push_continuePublishing, tag_gen)

def push_continuePublishing(tag_gen, index=0):
    global tags_sent, push_start_time, push_last_time_stamp, options
    
    if not stream_play:
        reactor.callLater(1.0, push_continuePublishing, tag_gen, index)
        return
    try:    
        connection = push_client.get_nc()
        if not connection:
            raise StopIteration
                
        limit = options.get('packets', 'unlimited')
        if limit != 'unlimited':
            if index >= int(limit):
                raise StopIteration
    
        tag = tag_gen.next()
        data, type, timestamp = tag["data"], tag["type"], tag["time_stamp"]
        ts_diff = timestamp - push_last_time_stamp
        if ts_diff < 0:
            ts_diff = 0
        data = connection.encoder.process(data, channelId, broadcast_stream_id, type, ts_diff)
        to_sleep = (ts_diff / 1000.0)
        if (to_sleep < 0) or (index < 1000): # First 1000 tags get sent as quickly as possible
            to_sleep = 0
        connection.write(data)
        tag['process_time'] = time.time()
    
        if tag['type'] == 9: 
            tags_sent.append(tag)
        push_last_time_stamp = timestamp
        reactor.callLater(to_sleep, push_continuePublishing, tag_gen, index + 1)
    except StopIteration:
        reactor.callLater(3, push_done, index)
          
    
def push_done(packets):
    log.msg("Done. Read %s packets"%packets)
    reactor.stop()

class fake_thing:
    def get_uptime(*args):
        return 1
    def plug(command, *args, **kwargs):
        log.msg("Command: %s"%command)
        log.msg(repr(args))
        log.msg(repr(kwargs))
        if command == 'invoke':
            log.msg('Got an invoke!!!')
            return True

push_core = None
push_client = None

def push():
    global file, push_core, push_client, options
    file = options['file']
    log.msg("file = %s, stream_key = %s" % (file, options['stream']))
    push_core = fake_thing()
    push_core.config = {'max_conn_per_ip': 666, 'max_conn': 666}
    push_core.name = "fake"
    push_core.nodes = {push_core.name: fake_thing()}
    #client = rtmp.RTMPServer(core, client=True, app=options['app'], tcUrl = "rtmp://%s/%s"%(options['host'], options['app']), swfUrl=options['swfurl'])
    params = {'flashVer' : 'PMS'}
    push_client = rtmp.RTMPServer(push_core, 
        client=True, 
        app=options['app'], 
        tcUrl = "rtmp://%s/%s" % (options['host'],options['app']), 
        swfUrl = options['swfurl'], 
        params=params )
    push_client.connectDeferred.addCallback(push_connected)
    log.msg("Connecting...")
    reactor.connectTCP(options['host'], int(options['port']), push_client)


##
#
# flvpuller
#
##


def pull_connected(result, options):
    log.msg("PULL CONNECTED!  args = %s" % result)
    pull_client.get_nc().server_bw('\x00\x13\x12\xd0')
    pull_client.get_nc().invoke('createStream', streamId)
    pull_client.get_nc().invoke('FCSubscribe', 0.0, stream_play, channel=amf.EVENT_CHANNEL);
    pull_client.createStreamDeferred.addCallback(play, options)
    pull_client.get_nc().ping('\x00\x03\x00\x00\x00\x00\x00\x00\x00d')

def play(result, options):
    global stream_token, stream_play
    if options['accesscode'] is not 'none':
        log.msg('Sending password "%s"' % options['accesscode'])
        pull_client.get_nc().invoke('NetStream.Authenticate.AccessCode', 0.0, options['accesscode'], insertNone=True, channel=amf.EVENT_CHANNEL)
        
    log.msg('Sending token %s' % stream_token)
    pull_client.get_nc().invoke('NetStream.Authenticate.UsherToken', 0.0, str(stream_token), insertNone=True, channel=amf.EVENT_CHANNEL)
    
    log.msg("PULL STREAM CREATED!  Getting %s  args = %s" % (stream_play, result))
    log.msg("Stream id is %s" % streamId)
    if streamId not in pull_client.get_nc().streams:
        pull_client.get_nc().create_netstream(streamId)
    pull_client.get_nc().invoke('receiveVideo', 0.0, True, streamId=1.0)
    pull_client.get_nc().invoke('play', 0.0, [stream_play, -2000.0], streamId=1.0)
    pull_client.get_nc().invoke('play', 0.0, [stream_play, -2000.0], streamId=result[3])
    pull_client.get_nc().ping('\x00\x03\x00\x00\x00\x01\x00\x00\x00d')
    
def pull_success(result, options):
    global streamId, pull_start_time, pull_client, pull_success_flag
    log.msg("PULL SUCCESS! %s" % result)
    pull_success_flag = True
    pull_start_time = time.time()
    log.msg('Available netstream ids are: %s' % pull_client.get_nc().streams.keys())
    pull_client.get_nc().streams[streamId].stream = Processor(options)
    pull_client.get_nc().streams[1].stream = Processor(options)
        
class AuthenticationHandler():
    
    def callback(self, args):
        log.msg('Stream requires a password and you did not supply the correct one.')
        log.msg(`args`)
        os._exit(-1)
            
last_time_stamp = 0

class Processor:
    
    def __init__(self, opt = {}):
        self.options = opt
        self.count = 0
        
    def addPackets(self, packets):
        for tag in packets: 
            tag['process_time'] = time.time()
            if tag['type'] == 9: tags_received.append(tag)
            self.count += 1
            
            
                        
def failure(result, options):
    log.msg("FAILURE! %s" % result)
    description = results.value[-1]["description"]
    os._exit(-1)
            

class fake_thing:
    def get_uptime(*args):
        return 1
        
    def plug(command, *args, **kwargs):
        log.msg('Command: %s')
        log.msg(repr(args))
        log.msg(repr(kwargs))
        if command == 'invoke':
            log.msg('Got an invoke!!!')
            return True

pull_core = None

def make_core():
    global pull_core
    pull_core = fake_thing()
    pull_core.config = {'max_conn_per_ip': 666, 'max_conn': 666}
    pull_core.name = "fake"
    pull_core.nodes = {pull_core.name: fake_thing()}

pull_client = None

@connection.BackoffRetry()
def play_from(options):
    global pull_client, pull_core, stream_play
    
    if not stream_play:
        if not get_stream_play():
            log.msg("Failed to find stream...")        
            return False
    
    log.msg("PLAY: %s"%stream_play)        
    log.msg("TOKEN: %s"%stream_token)        
    
    make_core()
    log.msg("Connecting to %s:%s..." % (options['host'], options['port']))
    params = {'flashVer' : 'PMS'}
    pull_client = rtmp.RTMPServer(pull_core, 
        client=True, 
        app=options['app'], 
        tcUrl = "rtmp://%s/%s" % (options['host'],options['app']), 
        swfUrl = options['swfurl'], 
        pageUrl = options['pageurl'], 
        params=params )
    pull_client.connectDeferred.addCallback(pull_connected, options)
    pull_client.playDeferred.addCallback(pull_success, options)
    pull_client.otherDeferreds['NetStream.Authenticate.Failed'] = AuthenticationHandler()
    reactor.connectTCP(options['host'], int(options['port']), pull_client)
    return True

def pull():
    global options
    play_from(options)
    
def timeout(options):
    log.msg("Timeout checking stream %s (%.2fs)" % (options['stream'], float(options['timeout'])))
    os._exit(-1)
    
def get_stream_play():
    global  options, stream_token, stream_play
    pass_clause = ""
    if options['accesscode']:
        pass_clause="&private_code=%s"%options['accesscode']
    #conn = httplib.HTTPConnection("%s:8925"%options['host'])
    conn = httplib.HTTPConnection("usher.justin.tv")
    conn.request("GET", "/find/%s.json?force_node=%s%s&with_origin=%s"%(options['stream_name'], options['host'], pass_clause, options['host']))
    page = conn.getresponse().read()
    find_json = simplejson.loads(page)
    if not find_json or not 'token' in find_json[0] or not 'play' in find_json[0]:
        return False
    stream_play = str(find_json[0]['play'])
    stream_token = str(find_json[0]['token']) 
    return True 

def calculate_mean_latency():
    total = 0.0
    n = 0
    s = 0
    r = 0
    while s < len(tags_sent) and r < len(tags_received):
        if tags_sent[s]['data'] == tags_received[r]['data']: 
            total += tags_received[r]['process_time'] - tags_sent[s]['process_time']    
            n += 1
            r += 1
            s += 1
        else:
            s += 1
    return total/float(n)

if __name__ == "__main__":
    class Options(usage.Options):
        optFlags = [
            ['verbose', 'v', 'Detailed logging'],
            ['akamai', 'K', 'Run in akamai mode']
        ]
        optParameters = [
            ['file', 'f', 'auto', 'File to stream'],
            ['stream', 's', 'stream_key', 'Stream key'],
            ['host', 'h', '127.0.0.1', 'RTMP server'],
            ['port', 'p', '1935', 'RTMP port'],
            ['packets', 'n', 'unlimited', 'Number of packets to capture'],
            ['swfurl', 'w', 'http://www.justin.tv/test.swf', 'swfUrl'],
            ['pageurl', 'W', 'http://justin.tv/justin', 'pageUrl'],
            ['app', 'a', 'app', 'Application name'],
            ['timeout', 't', 'none', 'Timeout in seconds'],
            ['accesscode', 'P', 'none', 'Stream access code'],
            ['stream_name', 'c', '', 'Name of stream to which to broadcast'],
            ['outfile', 'o', 'stdout', 'Output file'],
        ]    
    options = {}
    try:
        options = Options()
        options.parseOptions()
    except usage.UsageError, errortext:
        print '%s: %s' % (sys.argv[0], errortext)
        print '%s: Try --help for usage details.' % (sys.argv[0])
        sys.stdout.flush()
        os._exit(-1)
    if not options['file']:
        print "ERROR - No file name specified.  Use the -f option to specify the input file."
        os._exit(-1)
    if not options['stream']:
        print "ERROR - No stream key specified.  Use the -s option."
        os._exit(-1)
    if not options['stream_name']:
        print "ERROR - No stream name specified.  Use the -c option."
        os._exit(-1)
    
    if options['verbose']:
        log.startLogging(sys.stdout)
    
    if options['akamai']:
        broadcast_stream_id = streamId
        
    try:
        if options['outfile'] != "stdout":
            sys.stdout = open(options['outfile'], "w")
        
        push()
        pull()

        if options['timeout'] != 'none':
            reactor.callLater(float(options['timeout']), timeout, options)
        
        reactor.run()        
        print "Video latency on %s:%s"%(options['host'], calculate_mean_latency())
    except:  
        log.msg(sys.exc_info())
        os._exit(-1)
    
