#!/usr/bin/env python
#
# Repair the time stamps on a flv file by sorting 
#
#
#
import flvtools.flv as flv
import optparse
import sys
__p = optparse.OptionParser()
__p.add_option('--sort', dest='sort', action='store_true', help='Sort tags by time stamp in a moving window ', default=False)
__p.add_option('-f', '--sort-frame', dest='sort_frame', help='Length of window in which tags will be sorted', default=100, type='int')
__p.add_option('--shift', dest='shift', action='store_true', help='Shift the time stamp of tags that fall out of the progression of time stamps', default=False)
__p.add_option('-x', '--max-delta', dest='max_delta', help='Max difference to allow between successive time stamps', default=1000, type='int')
__p.add_option('-m', '--min-delta', dest='min_delta', help='Min difference to allow between successive time stamps', default=-1000, type='int')
__p.add_option('-n', '--new-delta', dest='new_delta', help='Difference at which shifted tags will be set', default=1, type='int')
__p.add_option('-w', '--write-buffer', dest='write_buffer', help='Number of tags to buffer before writing to disk', default=1000, type='int')

__options, __args = __p.parse_args()

if len(__args) < 2:
    print "Missing in or out file name"
    sys.exit(1)

if len(__args) > 2:
    print "Too many parameters"
    sys.exit(1)

in_filename = __args[0]
out_filename = __args[1]

if in_filename == '-':
    in_file = sys.stdin
else:
    in_file = open(in_filename, 'r')

if out_filename == '-':
    out_file = sys.stdout
    sys.stdout = open('repair_flv.out', 'w')
else:
    out_file = open(out_filename, 'w')
    

flv.repair_time_stamps(in_file, out_file, 
                          sort = __options.sort, 
                          sort_buffer_length = __options.sort_frame, 
                          shift = __options.shift, 
                          max_delta = __options.max_delta, 
                          min_delta = __options.min_delta, 
                          new_delta = __options.new_delta, 
                          out_buffer_length = __options.write_buffer)