#!/usr/bin/env python
#
# Sync timestamps accross multiple flv streams/files 
#
#
#
from __future__ import with_statement  
from twisted.python import log
import flvtools.flv as flv
import StringIO
import threading
import optparse
import sys
import time
__p = optparse.OptionParser()
__p.add_option('-w', '--write-buffer', dest='write_buffer', help='Number of tags to buffer before writing to disk', default=64, type='int')
__p.add_option('-l', '--log', dest='log', help='Log file', default='/var/log/sync_timestamps.out', type='string')
__options, __args = __p.parse_args()

if len(__args) % 2 != 0:
    log.msg("odd number of args")
    sys.exit(1)

done = False
offset_lock = threading.Lock()

streams = []
dest_stream = None

def sync_file(stream):
    global done, offset_lock, dest_stream
    tags_writen = 0
    log.msg("syncing %s to %s"%(stream['in_file_name'], stream['out_file_name']))
    stream['out_buff'] = StringIO.StringIO()
    stream['out_buff_c'] = 0
    stream['offset'] = 0
    stream['in_file'] = open(stream['in_file_name'], 'r')
    stream['out_file'] = open(stream['out_file_name'], 'w')
    stream['last_offset_adjustment'] = 0
    stream['first_update'] = False
    write_buffered(flv.writeHeader(), stream)
    tags = flv.readFile(stream['in_file'], chunk_size=1024)
    for t in tags:
        if done:
            return 
        t['time_stamp'] += stream['offset']
        with offset_lock:
            stream['last_tag_time'] = t['time_stamp']
            if (time.time() - stream['last_offset_adjustment'] > 60) or not stream['first_update']:
                stream['last_offset_adjustment'] = time.time()
                if dest_stream and 'last_tag_time' in dest_stream:
                    stream['first_update'] = True
                offset_delta = get_offset(stream)
                stream['offset'] += offset_delta
                t['time_stamp'] += offset_delta 
                if stream['first_update']:
                    log.msg("%s to %s offset to %s"%(stream['in_file_name'], stream['out_file_name'], stream['offset']))
        write_buffered(flv.writeTag(t, t['time_stamp']), stream)   
        tags_writen += 1
    flush_buffer(stream)
    log.msg("done (wrote %s tags)"%tags_writen)
    done = True           
                              
def get_offset(stream):
    global streams, dest_stream 
    if dest_stream and 'last_tag_time' in dest_stream:
        return dest_stream['last_tag_time'] - stream['last_tag_time']
    else:
        return 0
    
def write_buffered(data, stream):
    if __options.write_buffer > 0:
        stream['out_buff'].write(data)
        stream['out_buff_c'] += 1
        if stream['out_buff_c'] > __options.write_buffer:
            flush_buffer(stream)
    else:
        stream['out_file'].write(data)

def flush_buffer(stream):         
    if __options.write_buffer > 0:
        stream['out_file'].write(stream['out_buff'].getvalue())
        stream['out_buff_c'] = 0
        stream['out_buff'] = StringIO.StringIO()


if __options.log == '-':
    log.startLogging(sys.stdout)
else:
    log.startLogging(open(__options.log, 'w'))

for i in range(len(__args)/2):
    log.msg("starting sync thread %s"%i)
    stream = {}
    stream['in_file_name'] = __args[i*2] 
    stream['out_file_name'] = __args[i*2+1]
    streams.append(stream)
    t = threading.Thread(target=sync_file, args = [stream])
    t.start()

with offset_lock:
    dest_stream = streams[-1]
    
while not done:
    time.sleep(10)
    with offset_lock:
        log.msg('----')
        for s in streams:
            if 'last_tag_time' in s:
                log.msg("%s to %s last time code: %s"%(s['in_file_name'], s['out_file_name'], s['last_tag_time']))
    
    

