#!/usr/bin/env python
from twisted.internet import reactor, defer
from twisted.python import log, usage
import time, sys, os, traceback, optparse


from flvtools import flv
from flvtools.rtmp import amf_py as amf
from flvtools.factories import rtmp

import time, sys, os, traceback
import hmac, hashlib, re

def hex_md5(salt):
    return hashlib.md5(salt).hexdigest()
    
def invoke_akamai(data, ns):
    "Handle the authenticate"
    logstr('data %s' % repr(data)) 
    if not len(data): return None
    command = data[0]
    if command == 'setChallenge':
        try:
            session_id = int(data[3])
            challenge = data[4]
            log.msg('Akamai session_id %s challenge %s' % (session_id, challenge))
            session_key = ns.nc.factory.session + ":" + str(session_id)
            response = hex_md5(challenge + ":" + ns.nc.factory.password + 
                hex_md5(session_key + ":" + challenge + ":" + ns.nc.factory.password))
            log.msg('Calling ClientLogin with %s %s' % (session_key, response))
            ns.nc.invoke('ClientLogin', 0.0, [session_key, response], channel=amf.EVENT_CHANNEL)
        except:
            log.msg('Unable to set Akamai challenge string:')
            log.err()
        return True
    elif command == 'onClientLogin':
        result = data[3]
        if result['code'] == "Akamai.Connect.Success":
            log.msg('Akamai ClientLogin success')
            ns.nc.factory.setAuthorization(True)
        else:
            log.msg('Akamai ClientLogin failure: %s' % result['code'])
            log.msg('Details:\n%s' % result)
            ns.nc.factory.setAuthorization(False)
    else:
        log.msg(data)
        return None
        
        

def logstr(msg):
    log.msg(msg)

class fake_thing: 
    def __init__(self, ip):
        self.public_ip = ip
    def get_uptime(self, *args):
        return 1
        
    def plug(self, command, *args, **kwargs):
        logstr('Command: %s' % command)
        logstr(repr(args))
        logstr(repr(kwargs))
        if command == 'invoke':
            logstr('Got an invoke!!!')
            return invoke_akamai(*args, **kwargs)

core = None

def make_core(ip):
    global core
    core = fake_thing(ip)
    core.config = {'max_conn_per_ip': 666, 'max_conn': 666, 'wowza_port': 1935}
    core.name = "fake"
    core.nodes = {core.name: fake_thing(ip)}

@defer.inlineCallbacks
def akamai_publish(akamai_name, password, ip):
    global core
    logstr("Starting akamai publish for %s" % akamai_name)
    make_core(ip)
    cpcode = 60346
    entry_point = 'p.ep%s.i.akamaientrypoint.net' % akamai_name.split('@')[1]
    app = 'EntryPoint?authmod=adobe&user=%s' % cpcode
    swfUrl = tcUrl = 'rtmp://%s/%s' % (entry_point, app)
    session = "origin:" + ip + ":" + str(cpcode)
    params = {'flashVer' : 'PMS'} # Needed to tell FMS that we are not FME! (Different interface)
    
    client = rtmp.RTMPServer(core, client=True, swfUrl=swfUrl, app='EntryPoint',
        tcUrl=tcUrl, session=session, params=params, password=password)
    reactor.connectTCP(entry_point, 1935, client)
    yield client.authDeferred
    stream = akamai_name
    try:
        log.msg('Calling FCAnnounce for stream %s' % stream)
        client.get_nc().invoke("FCAnnounce", 0.0, stream, channel=amf.EVENT_CHANNEL)
        defer.returnValue(client)
        return
    except Exception:
        logmsg('Error announcing stream %s' % stream)
        
    defer.returnValue(client)
    return



def akamai_unpublish(client, akamai_name):
    stream = akamai_name
    try:
        log.msg('Calling FCUnannounce for stream %s' % stream)
        client.get_nc().invoke("FCUnannounce", 0.0, stream, channel=amf.EVENT_CHANNEL)
        return True
    except Exception:
        log.msg('Error unannouncing stream %s' % stream)
        log.err()
    return False 

