import cStringIO

class BufferedWriter(object):
    def __init__(self, out_stream, trigger_write_size):
        self.ostream = out_stream
        self.trigger_write = trigger_write_size

        self.strbuf = cStringIO.StringIO() 
        self.strbuf_size = 0

    def write(self, obj):
        s = str(obj)
        self.strbuf_size += len(s)
        self.strbuf.write(s)

        if self.strbuf_size >= self.trigger_write:
            self.flush()

    def flush(self):
        self.ostream.write(self.strbuf.getvalue())
        self.strbuf.close()
        self.strbuf = cStringIO.StringIO()
        self.strbuf_size = 0
