import time

# there is no nice way to do a circular array without 2.7; we'll just use a 
# list and modulus
class CB(object):
    def __init__(self, size):
        self.size = size
        self.idx = 0
        self.cb = [ None for i in xrange(0, size) ]

    def push(self, obj):
        self.cb[self.idx % self.size] = obj
        self.idx += 1

    def buffer_size(self):
        return self.size

    def num_pushed(self):
        return self.idx

    def head(self):
        if self.idx == 0:
            return None
        return self.cb[(self.idx - 1) % self.size]

    def tail(self):
        if self.idx < self.size:
            return self.cb[0]
        return self.cb[self.idx % self.size]

    def filled(self):
        return (self.idx >= self.size)

    def __len__(self):
        if self.idx < self.size:
            return self.idx
        else:
            return self.size

    def __getitem__(self, get_idx):
        def __inner_getitem__(idx):
            if idx >= self.size or idx >= self.idx or idx < 0:
                raise IndexError()

            if not self.filled():
                return self.cb[idx]
            else:  # we're pointing at idx 0 already
                return self.cb[(self.idx + idx) % self.size]

        if type(get_idx) == slice:
            # TODO: could be greatly optimized for the standard case where step = 1
            elem_range = xrange(get_idx.start or 0, get_idx.stop or sys.maxint, get_idx.step or 1)
            return [__inner_getitem__(idx) for idx in elem_range]
        else:
            return __inner_getitem__(get_idx)

    def __setitem__(self, idx, value):
        if idx >= self.size or idx >= self.idx or idx < 0:
            raise IndexError()

        if not self.filled():
            self.cb[idx] = value
        else:
            self.cb[(self.idx + idx) % self.size] = value

    def __delitem__(self, idx):
        if idx >= self.size or idx >= self.idx or idx < 0:
            raise IndexError()

        raise "TODO: CB.__delitem__ not implemented."
        
    def __iter__(self):
        if self.filled():
            for i in xrange(self.idx, self.idx + self.size):
                yield self.cb[i % self.size]
        else:
            for i in xrange(0, self.idx):
                yield self.cb[i]

