"""

    File: messages.py
    Description: 
    
        Module to encode and decode encoded messages from Spread.

    Author: Kyle Vogt
    Date  : June 5th, 2007
    Copyright (c) 2007, Justin.tv, Inc.
    
"""

from twisted.python import log
import cPickle, struct, time, zlib

headerLength = 12
UP, DOWN, ANNOUNCE, ANNOUNCE_ACK, REGULAR_MESSAGE, MEMBERSHIP_MESSAGE, META, KILL = range(8)
SPREAD_FIFO_MESS = 4
        
def new(sender, type, objects):
    return {'sender' : sender, 'type' : type, 'objects' : objects}

def decodeMessage(data):
    "Return a decoded message as a python dict"
    if len(data) < headerLength: return False
    length, tc = struct.unpack("!Id", data[0 : headerLength])
    if len(data) < (headerLength + length): return False
    message = cPickle.loads(zlib.decompress(data[headerLength:]))
    message['timecode'] = tc
    return message
            
def encodeMessage(object):
    "Encode the entire message"
    data = zlib.compress(cPickle.dumps(object, cPickle.HIGHEST_PROTOCOL))
    tc = time.time()
    header = struct.pack("!Id", len(data), tc)
    return header + data
    
def string(message):
    if message == UP:
        return 'up'
    elif message == DOWN:
        return 'down'
    elif message == META:
        return 'meta'
    elif message == ANNOUNCE:
        return 'announce'
    elif message == ANNOUNCE_ACK:
        return 'announce_ack'
    elif message == KILL:
        return 'kill'
    else:
        return ''
        
