import struct

cont_atom_types = ['moov', 'trak', 'mdia', 'minf', 'dinf', 'stbl']


def readAtom(data, offset):
    if len(data[offset:]) < 8:
        print "no header"
        #not enough dataa for length and type fields 
        return False
    length = struct.unpack("!I", data[offset: offset + 4])[0]
    print "got length %s"%length
    type = data[offset + 4:offset + 8]
    print "got type %s"%type
    if len(data[offset:]) < length:
        print "not enough data for body"
        return False
    return {'type':type, 'length':length, 'data':data[offset + 8: offset + length]}
        

def readData(data):
    #pos in data array
    pointer = 0
    #number of bytes written
    counter = 0
    while True:
        atom = readAtom(data, pointer)
        if atom:
            atom['byte_offset'] = counter
            counter += atom['length']
            pointer += atom['length']
            yield atom
        else:
            return
    
def readFile(file_object, chunk_size = 8192):
    data = file_object.read(chunk_size)
    print "got %s bytes"%len(data)
    
    #pos in data array
    pointer = 0
    #number of bytes written
    counter = 0
    while True:
        atom = readAtom(data, pointer)
        if atom:
            atom['byte_offset'] = counter
            counter += atom['length']
            pointer += atom['length']
            yield atom
        else:
            newdata = file_object.read(chunk_size)	    
            if newdata: 
                data += newdata
                data = data[pointer:]
                pointer = 0
            else: 
                return

def outputAtom(atom):
    length = struct.pack("!I", int(atom['length']))
    return length + atom['type'] + atom['data']

def writeAtom(fileObject, atom):
        fileObject.write(outputAtom(atom))


def shift_chunk_offsets(moov_atom, shift):
    assert moov_atom['type'] == 'moov'
    locs = get_atoms_offsets(moov_atom, 'stoc')
    for l in locs:
        start = l - 8
        chunk_count = struct.unpack("!I", moov_atom['data'][l + 4: l + 8])[0]
        print "got %s chunks"%chunk_count
        for i in range(chunk_count):
            cur_offset = struct.unpack("!I", moov_atom['data'][l + 8 + 4*i: l + 12 + 4*i])[0]
            moov_atom['data'][l + 8 + 4*i: l + 12 + 4*i] = struct.pack("!I", int(cur_offset + shift))
        
def get_atoms_offsets(atom, type):
    return get_atoms_offsets_rec(atom, type)

def get_atoms_offsets_rec(atom, type, offset = 0):
    if atom['type'] == type:
        return [offset]
    rtn = []
    offset += 8
    if atom['type'] in cont_atom_types:
        children = readData(atom['data'])
        for c in children:
            rtn += get_atoms_offsets_rec(c, type, offset)
            offset += c['length']
    return rtn

def parse_moov(moov):
    tracks = []
    trac_locs = get_atoms_offsets(moov, 'trak')
    for l in trac_locs:
        tracks.append(parse_trac(readAtom(moov['data'], l - 8)))
    return tracks
    

def parse_trac(trac_atom):
    trac = {}
    meida_loc = get_atoms_offsets(trac_atom, 'mdia')
    assert len(meida_loc) == 1
    media_atom = readAtom(trac_atom['data'], meida_loc[0] - 8)
    assert media_atom
    
    
    media_header_loc = get_atoms_offsets(media_atom, 'mdhd')
    assert len(media_header_loc) == 1
    trac['timescale'] = struct.unpack("!I", media_atom['data'][media_header_loc[0] + 12:media_header_loc[0] + 16])[0]
    
    sample_table_loc = get_atoms_offsets(media_atom, 'stbl')
    assert len(sample_table_loc) == 1
    sample_table_atom = readAtom(media_atom['data'], sample_table_loc[0] - 8)
    assert sample_table_atom
    
    print "got sample_table_atom: %s"%sample_table_atom
    media_atoms = readData(sample_table_atom['data'])
    
    for atom in media_atoms:
        print "got subatom %s"%atom
        
        
        if atom['type'] == 'stsd':
            print "parsing sample description atom"
            p = 12
            trac['type'] = atom['data'][p:p+4]
            
            avc_sequence_loc = atom['data'].find('avcC') 
            if avc_sequence_loc >= 0: 
                avc_header_atom = readAtom(atom['data'], avc_sequence_loc - 4)
                assert avc_header_atom
                trac['avc_sequence_header'] =  avc_header_atom['data']
            else:
                #todo: find aac sequence header atom
                pass
            
        elif atom['type'] == 'stts':
            print "parsing time to sample atom"
            p = 4
            entry_count = struct.unpack("!I", atom['data'][p:p+4])[0]
            p += 4
            print "%s items in table"%entry_count
            trac['time_to_sample'] = []
            for i in range(entry_count):
                sample_count = struct.unpack("!I", atom['data'][p:p+4])[0]
                p += 4
                sample_duration = struct.unpack("!I", atom['data'][p:p+4])[0]
                p += 4
                trac['time_to_sample'].append([sample_count, sample_duration])
            
        elif atom['type'] == 'stss':
            print "parsing sync sample atom"
            p = 4
            entry_count = struct.unpack("!I", atom['data'][p:p+4])[0]
            p += 4
            print "%s items in table"%entry_count
            trac['sync_sample'] = []
            for i in range(entry_count):
                sample = struct.unpack("!I", atom['data'][p:p+4])[0]
                p += 4
                trac['sync_sample'].append(sample)
        
        elif atom['type'] == 'stsc':
            print "parsing sample to chunk atom"
            p = 4
            entry_count = struct.unpack("!I", atom['data'][p:p+4])[0]
            p += 4
            print "%s items in table"%entry_count
            trac['sample_to_chunk'] = []
            for i in range(entry_count):
                first_chunk = struct.unpack("!I", atom['data'][p:p+4])[0]
                p += 4
                samples_per_chunk = struct.unpack("!I", atom['data'][p:p+4])[0]
                p += 4
                sample_type = struct.unpack("!I", atom['data'][p:p+4])[0]
                p += 4
                trac['sample_to_chunk'].append((first_chunk, samples_per_chunk, sample_type))    
        elif atom['type'] == 'stco':
            print "parsing chunk offset atom"
            p = 4
            entry_count = struct.unpack("!I", atom['data'][p:p+4])[0]
            p += 4
            print "%s items in table"%entry_count
            trac['chunk_offsets'] = []
            for i in range(entry_count):
                offset = struct.unpack("!I", atom['data'][p:p+4])[0]
                trac['chunk_offsets'].append(offset)
                p += 4
        
        elif atom['type'] == 'stsz':
            print "parsing sample size atom"
            p = 8
            entry_count = struct.unpack("!I", atom['data'][p:p+4])[0]
            p += 4
            print "%s items in table"%entry_count
            trac['sample_sizes'] = []
            for i in range(entry_count):
                size = struct.unpack("!I", atom['data'][p:p+4])[0]
                trac['sample_sizes'].append(size)
                p += 4
        
        else:
            print "unknown atom type %s"%atom['type']
    return trac         
    
    
    
            
        
        
        
        
    
    
    


