"""
    Author: William Bland
    Date  : May 7th, 2008
    Copyright (c) 2008, Justin.tv, Inc.
    
"""
from twisted.python import log
from twisted.internet import reactor
from flvtools.rtmp import amf_py as amf
from flvtools import flv
import struct, time, traceback

class BasicNetStream:
    def __init__(self, nc, streamId):
        self.streamId = int(streamId)
        self.nc = nc
        self.stream = None
        self.playing = False
        self.playTime = time.time()
        self.publishing = False
        self.startTime = None
        self.objects = []
        self.sentKey = False
        self.chunks = []
        self.chunkBytes = 0
        self.byteOffset = 0
        self.waitingVP6 = False
        self.waitingSOR = False
        self.elapsed = 0
        self.core = nc.factory.core
        self.play_data = None
        self.running = True

    def close(self):
        "Reset the NetStream so we can play a new stream"
        self.stop()
        self.stream = None

    def stop(self):
        pass
