"""

    File: framedropper.py
    Description: 
    
        This class overrides IPushProducer for streaming flash video.  By using this interface, the FileDescriptor
        can call pauseProducing() on this class, which tells the host application that the client can't read any 
        more data.  This prevents the server's memory from filling up due to TCP buffers growing indefinitely.

    Author: Kyle Vogt
    Date  : August 14th, 2007
    Copyright (c) 2007, Justin.tv, Inc.
    
"""

from twisted.internet import interfaces
from twisted.python import log
from zope.interface import implements
import time

class FrameDropper:
    implements(interfaces.IPushProducer)
    
    def __init__(self):
        self.done = False
        self.paused = False
        self.consumer = None
        
    def setConsumer(self, consumer):
        "Register this IPushProducer with the supplied consumer"
        self.consumer = consumer
        consumer.registerProducer(self, True)
        
    def pauseProducing(self):
        "Stop sending data and drop down to a lower mode"
        self.paused = True
        
    def resumeProducing(self):
        "Resume sending data"
        self.paused = False
    
    def stopProducing(self):
        "Shut down the protocol"
        self.done = True
        if self.consumer:
            self.consumer.unregisterProducer()

                
